/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.debug;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.StringTokenizer;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.plugins.dndviewer.Canvas;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Bounds;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Color;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Image;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Location;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Shape;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Text;

public class DebugCanvasAbsolute
implements Canvas {
    private final DebugString buffer;
    private final int level;
    private int offsetX;
    private int offsetY;

    public DebugCanvasAbsolute(DebugString buffer, Bounds bounds) {
        this(buffer, 0, bounds.getX(), bounds.getY());
    }

    private DebugCanvasAbsolute(DebugString buffer, int level, int x, int y) {
        this.level = level;
        this.buffer = buffer;
        this.offsetX = x;
        this.offsetY = y;
    }

    public void clearBackground(View view, Color color) {
        this.indent();
        this.buffer.appendln("Clear background of " + view + " to " + color + this.line());
    }

    public Canvas createSubcanvas() {
        this.buffer.blankLine();
        this.indent();
        this.buffer.appendln("Create subcanvas for same area");
        return new DebugCanvasAbsolute(this.buffer, this.level + 1, this.offsetX, this.offsetY);
    }

    public Canvas createSubcanvas(Bounds bounds) {
        return this.createSubcanvas(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
    }

    public Canvas createSubcanvas(int x, int y, int width, int height) {
        this.indent();
        int dx = this.offsetX + x;
        int qx = dx + width - 1;
        int dy = this.offsetY + y;
        int qy = dy + height - 1;
        this.buffer.appendln("Canvas " + dx + "," + dy + " " + width + "x" + height + " (" + qx + "," + qy + ") " + this.line());
        return new DebugCanvasAbsolute(this.buffer, this.level + 1, dx, dy);
    }

    public void draw3DRectangle(int x, int y, int width, int height, Color color, boolean raised) {
        this.indent();
        int px = this.offsetX + x;
        int py = this.offsetY + y;
        int qx = px + width - 1;
        int qy = py + height - 1;
        this.buffer.appendln("Rectangle (3D) " + px + "," + py + " " + width + "x" + height + " (" + qx + "," + qy + ") " + this.line());
    }

    public void drawImage(Image image, int x, int y) {
        this.indent();
        int px = this.offsetX + x;
        int py = this.offsetY + y;
        int qx = px + image.getWidth() - 1;
        int qy = py + image.getHeight() - 1;
        this.buffer.appendln("Icon " + px + "," + py + " " + image.getWidth() + "x" + image.getHeight() + " (" + qx + "," + qy + ") " + this.line());
    }

    public void drawImage(Image image, int x, int y, int width, int height) {
        this.indent();
        int px = this.offsetX + x;
        int py = this.offsetY + y;
        int qx = px + width - 1;
        int qy = py + height - 1;
        this.buffer.appendln("Icon " + px + "," + py + " " + width + "x" + height + " (" + qx + "," + qy + ") " + this.line());
    }

    public void drawLine(int x, int y, int x2, int y2, Color color) {
        this.indent();
        int px = this.offsetX + x;
        int py = this.offsetY + y;
        int qx = this.offsetX + x2;
        int qy = this.offsetY + y2;
        this.buffer.appendln("Line from " + px + "," + py + " to " + qx + "," + qy + " " + color + this.line());
    }

    public void drawLine(Location start, int xExtent, int yExtent, Color color) {
        this.indent();
        this.buffer.appendln("Line from " + start.getX() + "," + start.getY() + " to " + (start.getX() + xExtent) + "," + (start.getY() + yExtent) + " " + color + this.line());
    }

    public void drawOval(int x, int y, int width, int height, Color color) {
        this.indent();
        int px = this.offsetX + x;
        int py = this.offsetY + y;
        this.buffer.appendln("Oval " + px + "," + py + " " + width + "x" + height + " " + color + this.line());
    }

    public void drawRectangle(int x, int y, int width, int height, Color color) {
        this.indent();
        int px = this.offsetX + x;
        int py = this.offsetY + y;
        int qx = px + width - 1;
        int qy = py + height - 1;
        this.buffer.appendln("Rectangle " + px + "," + py + " " + width + "x" + height + " (" + qx + "," + qy + ") " + color + this.line());
    }

    private String line() {
        RuntimeException e = new RuntimeException();
        StringWriter s = new StringWriter();
        PrintWriter p = new PrintWriter(s);
        e.printStackTrace(p);
        StringTokenizer st = new StringTokenizer(s.toString(), "\n\r");
        st.nextElement();
        st.nextElement();
        st.nextElement();
        String line = st.nextToken();
        return line.substring(line.indexOf(40));
    }

    public void drawRectangleAround(View view, Color color) {
        Bounds bounds = view.getBounds();
        this.indent();
        this.buffer.appendln("Rectangle 0,0 " + bounds.getWidth() + "x" + bounds.getHeight() + " " + color + this.line());
    }

    public void drawRoundedRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight, Color color) {
        this.indent();
        int px = this.offsetX + x;
        int py = this.offsetY + y;
        int qx = px + width - 1;
        int qy = py + height - 1;
        this.buffer.appendln("Rounded Rectangle " + px + "," + py + " " + width + "x" + height + " (" + qx + "," + qy + ") " + color + this.line());
    }

    public void drawShape(Shape shape, Color color) {
        this.indent();
        this.buffer.appendln("Shape " + shape + " " + color);
    }

    public void drawShape(Shape shape, int x, int y, Color color) {
        this.indent();
        int px = this.offsetX + x;
        int py = this.offsetY + y;
        this.buffer.appendln("Shape " + shape + " at " + px + "," + py + " (left, top)" + " " + color + this.line());
    }

    public void drawSolidOval(int x, int y, int width, int height, Color color) {
        this.indent();
        int px = this.offsetX + x;
        int py = this.offsetY + y;
        int qx = px + width - 1;
        int qy = py + height - 1;
        this.buffer.appendln("Oval (solid) " + px + "," + py + " " + width + "x" + height + " (" + qx + "," + qy + ") " + color + this.line());
    }

    public void drawSolidRectangle(int x, int y, int width, int height, Color color) {
        this.indent();
        int px = this.offsetX + x;
        int py = this.offsetY + y;
        int qx = px + width - 1;
        int qy = py + height - 1;
        this.buffer.appendln("Rectangle (solid) " + px + "," + py + " " + width + "x" + height + " (" + qx + "," + qy + ") " + color + this.line());
    }

    public void drawSolidShape(Shape shape, Color color) {
        this.indent();
        this.buffer.appendln("Shape (solid) " + shape + " " + color);
    }

    public void drawSolidShape(Shape shape, int x, int y, Color color) {
        this.indent();
        int px = this.offsetX + x;
        int py = this.offsetY + y;
        this.buffer.appendln("Shape (solid)" + shape + " at " + px + "," + py + " (left, top)" + " " + color + this.line());
    }

    public void drawText(String text, int x, int y, Color color, Text style) {
        this.indent();
        int px = this.offsetX + x;
        int py = this.offsetY + y;
        this.buffer.appendln("Text " + px + "," + py + " \"" + text + "\" " + color + this.line());
    }

    public void drawText(String text, int x, int y, int maxWidth, Color color, Text style) {
        this.indent();
        int px = this.offsetX + x;
        int py = this.offsetY + y;
        this.buffer.appendln("Text " + px + "," + py + " +" + maxWidth + "xh \"" + text + "\" " + color + this.line());
    }

    private void indent() {
        for (int i = 0; i < this.level; ++i) {
            this.buffer.append((Object)"   ");
        }
    }

    public void offset(int x, int y) {
        this.offsetX += x;
        this.offsetY += y;
    }

    public boolean overlaps(Bounds bounds) {
        return true;
    }

    public String toString() {
        return "Canvas";
    }

    public void drawDebugOutline(Bounds bounds, int baseline, Color color) {
    }
}

