/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.table;

import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.commons.ensure.Assert;
import org.nakedobjects.metamodel.commons.exceptions.UnexpectedCallException;
import org.nakedobjects.metamodel.commons.exceptions.UnknownTypeException;
import org.nakedobjects.metamodel.facets.value.ImageValueFacet;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.metamodel.spec.feature.OneToManyAssociation;
import org.nakedobjects.metamodel.spec.feature.OneToOneAssociation;
import org.nakedobjects.plugins.dndviewer.CompositeViewSpecification;
import org.nakedobjects.plugins.dndviewer.Content;
import org.nakedobjects.plugins.dndviewer.ObjectContent;
import org.nakedobjects.plugins.dndviewer.TextParseableContent;
import org.nakedobjects.plugins.dndviewer.Toolkit;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.ViewAxis;
import org.nakedobjects.plugins.dndviewer.ViewFactory;
import org.nakedobjects.plugins.dndviewer.ViewRequirement;
import org.nakedobjects.plugins.dndviewer.ViewSpecification;
import org.nakedobjects.plugins.dndviewer.viewer.basic.UnlinedTextFieldSpecification;
import org.nakedobjects.plugins.dndviewer.viewer.builder.AbstractViewBuilder;
import org.nakedobjects.plugins.dndviewer.viewer.content.OneToOneFieldImpl;
import org.nakedobjects.plugins.dndviewer.viewer.content.TextParseableFieldImpl;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Location;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Padding;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Size;
import org.nakedobjects.plugins.dndviewer.viewer.table.TableAxis;
import org.nakedobjects.plugins.dndviewer.viewer.view.simple.BlankView;
import org.nakedobjects.plugins.dndviewer.viewer.view.simple.CompositeViewBuilder;
import org.nakedobjects.plugins.dndviewer.viewer.view.simple.FieldErrorView;
import org.nakedobjects.runtime.context.NakedObjectsContext;

class TableCellBuilder
extends AbstractViewBuilder {
    private static final Logger LOG = Logger.getLogger(TableCellBuilder.class);

    TableCellBuilder() {
    }

    private void addField(View view, NakedObject object, NakedObjectAssociation field) {
        NakedObject value = field.get(object);
        View fieldView = this.createFieldView(view, object, field, value);
        if (fieldView != null) {
            view.addView(this.decorateSubview(fieldView));
        } else {
            view.addView(new FieldErrorView("No field for " + value));
        }
    }

    public void build(View view) {
        Assert.assertEquals((String)"ensure the view is complete decorated view", (Object)view.getView(), (Object)view);
        Content content = view.getContent();
        NakedObject object = ((ObjectContent)content).getObject();
        TableAxis viewAxis = (TableAxis)view.getViewAxis();
        if (view.getSubviews().length == 0) {
            this.buildNew(object, view, viewAxis);
        } else {
            this.buildUpdate(object, view, viewAxis);
        }
    }

    private void buildUpdate(NakedObject object, View view, TableAxis viewAxis) {
        LOG.debug((Object)("update view " + view + " for " + object));
        View[] subviews = view.getSubviews();
        NakedObjectSpecification spec = object.getSpecification();
        for (int i = 0; i < subviews.length; ++i) {
            boolean changedValue;
            NakedObjectAssociation field = this.fieldFromActualSpec(spec, viewAxis.getFieldForColumn(i));
            View subview = subviews[i];
            NakedObject value = field.get(object);
            if (field.getSpecification().isParseable()) {
                boolean valueChange;
                boolean visiblityChange = !field.isVisible(NakedObjectsContext.getAuthenticationSession(), object).isAllowed() ^ subview instanceof BlankView;
                NakedObject nakedObject = subview.getContent().getNaked();
                boolean bl = valueChange = value != null && value.getObject() != null && !value.getObject().equals(nakedObject.getObject());
                if (visiblityChange || valueChange) {
                    View fieldView = this.createFieldView(view, object, field, value);
                    view.replaceView(subview, this.decorateSubview(fieldView));
                }
                subview.refresh();
                continue;
            }
            if (!field.isOneToOneAssociation()) continue;
            NakedObject existing = ((ObjectContent)subviews[i].getContent()).getObject();
            boolean bl = changedValue = value != existing;
            if (!changedValue) continue;
            View fieldView = this.createFieldView(view, object, field, value);
            if (fieldView != null) {
                view.replaceView(subview, this.decorateSubview(fieldView));
                continue;
            }
            view.addView(new FieldErrorView("No field for " + value));
        }
    }

    private NakedObjectAssociation fieldFromActualSpec(NakedObjectSpecification spec, NakedObjectAssociation field) {
        String fieldName = field.getId();
        return spec.getAssociation(fieldName);
    }

    private void buildNew(NakedObject object, View view, TableAxis viewAxis) {
        LOG.debug((Object)("build view " + view + " for " + object));
        int len = viewAxis.getColumnCount();
        NakedObjectSpecification spec = object.getSpecification();
        for (int f = 0; f < len; ++f) {
            NakedObjectAssociation field = this.fieldFromActualSpec(spec, viewAxis.getFieldForColumn(f));
            this.addField(view, object, field);
        }
    }

    public View createCompositeView(Content content, CompositeViewSpecification specification, ViewAxis axis) {
        return new CompositeViewBuilder(content, specification, axis);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private View createFieldView(View view, NakedObject object, NakedObjectAssociation field, NakedObject value) {
        ViewSpecification cellSpec;
        TextParseableFieldImpl content;
        if (field == null) {
            throw new NullPointerException();
        }
        ViewFactory factory = Toolkit.getViewFactory();
        if (field instanceof OneToManyAssociation) {
            throw new UnexpectedCallException("no collections allowed");
        }
        if (!(field instanceof OneToOneAssociation)) throw new UnknownTypeException((Object)field);
        NakedObjectSpecification fieldSpecification = field.getSpecification();
        if (fieldSpecification.isParseable()) {
            content = new TextParseableFieldImpl(object, value, (OneToOneAssociation)field);
            if (content.getNaked() instanceof ImageValueFacet) {
                return new BlankView(content);
            }
            if (!field.isVisible(NakedObjectsContext.getAuthenticationSession(), object).isAllowed()) {
                return new BlankView(content);
            }
            cellSpec = ((TextParseableContent)content).getNoLines() > 0 ? new UnlinedTextFieldSpecification() : factory.getValueFieldSpecification(content);
        } else {
            OneToOneFieldImpl content2 = new OneToOneFieldImpl(object, value, (OneToOneAssociation)field);
            if (!field.isVisible(NakedObjectsContext.getAuthenticationSession(), object).isAllowed()) {
                return new BlankView(content2);
            }
            ViewSpecification cellSpec2 = factory.getIconizedSubViewSpecification(content2);
            return factory.createView(new ViewRequirement(content2, view.getViewAxis(), 8193));
        }
        ViewAxis axis = view.getViewAxis();
        return cellSpec.createView(content, axis);
    }

    public Size getRequiredSize(View row) {
        int maxHeight = 0;
        int totalWidth = 0;
        TableAxis axis = (TableAxis)row.getViewAxis();
        View[] cells = row.getSubviews();
        int maxBaseline = this.maxBaseline(cells);
        for (int i = 0; i < cells.length; ++i) {
            totalWidth += axis.getColumnWidth(i);
            Size s = cells[i].getRequiredSize(new Size());
            int b = cells[i].getBaseline();
            int baselineOffset = Math.max(0, maxBaseline - b);
            maxHeight = Math.max(maxHeight, s.getHeight() + baselineOffset);
        }
        return new Size(totalWidth, maxHeight);
    }

    public void layout(View row, Size maximumSize) {
        int x = 0;
        TableAxis axis = (TableAxis)row.getViewAxis();
        View[] cells = row.getSubviews();
        int maxBaseline = this.maxBaseline(cells);
        for (int i = 0; i < cells.length; ++i) {
            View cell = cells[i];
            Size s = cell.getRequiredSize(new Size(maximumSize));
            s.setWidth(axis.getColumnWidth(i));
            cell.setSize(s);
            int b = cell.getBaseline();
            int baselineOffset = Math.max(0, maxBaseline - b);
            cell.setLocation(new Location(x, baselineOffset));
            x += s.getWidth();
        }
        Padding padding = row.getPadding();
        Size size = new Size(padding.getLeftRight(), padding.getTopBottom());
        row.setSize(size);
    }

    private int maxBaseline(View[] cells) {
        int maxBaseline = 0;
        for (int i = 0; i < cells.length; ++i) {
            View cell = cells[i];
            maxBaseline = Math.max(maxBaseline, cell.getBaseline());
        }
        return maxBaseline;
    }
}

