/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.view.dialog;

import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.commons.ensure.Assert;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.plugins.dndviewer.ActionContent;
import org.nakedobjects.plugins.dndviewer.CompositeViewSpecification;
import org.nakedobjects.plugins.dndviewer.Content;
import org.nakedobjects.plugins.dndviewer.ObjectParameter;
import org.nakedobjects.plugins.dndviewer.ParameterContent;
import org.nakedobjects.plugins.dndviewer.SubviewSpec;
import org.nakedobjects.plugins.dndviewer.TextParseableParameter;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.ViewAxis;
import org.nakedobjects.plugins.dndviewer.viewer.builder.AbstractViewBuilder;
import org.nakedobjects.plugins.dndviewer.viewer.content.ObjectParameterImpl;
import org.nakedobjects.plugins.dndviewer.viewer.view.simple.CompositeViewBuilder;

public class ActionFieldBuilder
extends AbstractViewBuilder {
    private static final Logger LOG = Logger.getLogger(ActionFieldBuilder.class);
    private final SubviewSpec subviewDesign;

    public ActionFieldBuilder(SubviewSpec subviewDesign) {
        this.subviewDesign = subviewDesign;
    }

    public void build(View view) {
        Assert.assertEquals((Object)view.getView(), (Object)view);
        ActionContent actionContent = (ActionContent)view.getContent();
        if (view.getSubviews().length == 0) {
            this.newBuild(view, actionContent);
        } else {
            this.updateBuild(view, actionContent);
        }
    }

    public View createCompositeView(Content content, CompositeViewSpecification specification, ViewAxis axis) {
        return new CompositeViewBuilder(content, specification, axis);
    }

    private View createFieldView(View view, ParameterContent parameter, int sequence) {
        View fieldView = this.subviewDesign.createSubview(parameter, view.getViewAxis(), sequence);
        if (fieldView == null) {
            throw new NakedObjectException("All parameters must be shown");
        }
        return fieldView;
    }

    public View decorateSubview(View subview) {
        return this.subviewDesign.decorateSubview(subview);
    }

    private void newBuild(View view, ActionContent actionContent) {
        LOG.debug((Object)("build new view " + view + " for " + actionContent));
        int noParameters = actionContent.getNoParameters();
        View focusOn = null;
        for (int f = 0; f < noParameters; ++f) {
            ParameterContent parameter = actionContent.getParameterContent(f);
            View fieldView = this.createFieldView(view, parameter, f);
            View decoratedSubview = this.decorateSubview(fieldView);
            view.addView(decoratedSubview);
            if (focusOn != null || !(parameter instanceof TextParseableParameter) || !fieldView.canFocus()) continue;
            focusOn = decoratedSubview;
        }
        if (focusOn != null) {
            view.getViewManager().setKeyboardFocus(focusOn);
        }
    }

    private void updateBuild(View view, ActionContent actionContent) {
        LOG.debug((Object)("rebuild view " + view + " for " + actionContent));
        View[] subviews = view.getSubviews();
        for (int i = 0; i < subviews.length; ++i) {
            View subview = subviews[i];
            Content content = subview.getContent();
            NakedObject subviewsObject = subview.getContent().getNaked();
            NakedObject invocationsObject = ((ActionContent)view.getContent()).getParameterObject(i);
            if (content instanceof ObjectParameter) {
                if (subviewsObject == invocationsObject) continue;
                ObjectParameterImpl parameter = new ObjectParameterImpl((ObjectParameterImpl)content, invocationsObject);
                View fieldView = this.createFieldView(view, parameter, i);
                view.replaceView(subview, this.decorateSubview(fieldView));
                continue;
            }
            subview.refresh();
        }
    }
}

