/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.view.field;

import org.nakedobjects.metamodel.adapter.InvalidEntryException;
import org.nakedobjects.metamodel.commons.exceptions.NotYetImplementedException;
import org.nakedobjects.metamodel.facets.value.ColorValueFacet;
import org.nakedobjects.plugins.dndviewer.Canvas;
import org.nakedobjects.plugins.dndviewer.Click;
import org.nakedobjects.plugins.dndviewer.Content;
import org.nakedobjects.plugins.dndviewer.TextParseableContent;
import org.nakedobjects.plugins.dndviewer.Toolkit;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.ViewAxis;
import org.nakedobjects.plugins.dndviewer.ViewRequirement;
import org.nakedobjects.plugins.dndviewer.ViewSpecification;
import org.nakedobjects.plugins.dndviewer.viewer.border.DisposeOverlay;
import org.nakedobjects.plugins.dndviewer.viewer.builder.AbstractFieldSpecification;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Color;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Location;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Size;
import org.nakedobjects.plugins.dndviewer.viewer.view.field.ColorFieldOverlay;
import org.nakedobjects.plugins.dndviewer.viewer.view.field.TextParseableFieldAbstract;

public class ColorField
extends TextParseableFieldAbstract {
    private int color;

    public ColorField(Content content, ViewSpecification specification, ViewAxis axis) {
        super(content, specification, axis);
    }

    public void draw(Canvas canvas) {
        Color color = this.hasFocus() ? Toolkit.getColor("color.primary1") : (this.getParent().getState().isObjectIdentified() ? Toolkit.getColor("color.identified") : (this.getParent().getState().isRootViewIdentified() ? Toolkit.getColor("color.primary2") : Toolkit.getColor("color.secondary1")));
        int top = 0;
        int left = 0;
        Size size = this.getSize();
        int w = size.getWidth() - 1;
        int h = size.getHeight() - 1;
        canvas.drawRectangle(left, top, w, h, color);
        canvas.drawSolidRectangle(++left, ++top, --w, --h, Toolkit.getColor(this.getColor()));
    }

    public void firstClick(Click click) {
        if (((TextParseableContent)this.getContent()).isEditable().isAllowed()) {
            DisposeOverlay overlay = new DisposeOverlay(new ColorFieldOverlay(this));
            Location location = this.getAbsoluteLocation();
            overlay.setLocation(location);
            this.getViewManager().setOverlayView(overlay);
        }
    }

    public int getBaseline() {
        return VPADDING + Toolkit.getText("text.normal").getAscent();
    }

    int getColor() {
        TextParseableContent content = (TextParseableContent)this.getContent();
        ColorValueFacet col = (ColorValueFacet)content.getSpecification().getFacet(ColorValueFacet.class);
        return col.colorValue(content.getNaked());
    }

    public Size getMaximumSize() {
        return new Size(45, 15);
    }

    protected void save() {
        try {
            this.parseEntry("" + this.color);
        }
        catch (InvalidEntryException e) {
            throw new NotYetImplementedException();
        }
    }

    void setColor(int color) {
        this.color = color;
        this.initiateSave(false);
    }

    public static class Specification
    extends AbstractFieldSpecification {
        public boolean canDisplay(Content content, ViewRequirement requirement) {
            return content.isTextParseable() && content.getSpecification().getFacet(ColorValueFacet.class) != null;
        }

        public View createView(Content content, ViewAxis axis) {
            return new ColorField(content, this, axis);
        }

        public String getName() {
            return "Color";
        }
    }
}

