/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.view.field;

import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.plugins.dndviewer.Canvas;
import org.nakedobjects.plugins.dndviewer.Content;
import org.nakedobjects.plugins.dndviewer.TextParseableContent;
import org.nakedobjects.plugins.dndviewer.Toolkit;
import org.nakedobjects.plugins.dndviewer.UserActionSet;
import org.nakedobjects.plugins.dndviewer.ViewAxis;
import org.nakedobjects.plugins.dndviewer.ViewSpecification;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Color;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Size;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Text;
import org.nakedobjects.plugins.dndviewer.viewer.view.field.ClearValueOption;
import org.nakedobjects.plugins.dndviewer.viewer.view.field.TextField;
import org.nakedobjects.runtime.context.NakedObjectsContext;

public class PasswordField
extends TextField {
    protected static final Text style = Toolkit.getText("text.normal");
    private int maxTextWidth;
    private char echoCharacter;

    public PasswordField(Content content, ViewSpecification design, ViewAxis axis) {
        super((TextParseableContent)content, design, axis, true, 1);
        this.setMaxTextWidth(20);
        String echoCharacterSetting = NakedObjectsContext.getConfiguration().getString("nakedobjects.viewer.dnd.echo");
        this.echoCharacter = echoCharacterSetting == null || echoCharacterSetting.equals(" ") ? (char)42 : echoCharacterSetting.charAt(0);
    }

    public void contentMenuOptions(UserActionSet options) {
        options.add(new ClearValueOption(this));
        options.setColor(Toolkit.getColor("color.background.menu.value"));
    }

    protected boolean provideClearCopyPaste() {
        return false;
    }

    public void delete() {
        this.textContent.deleteLeft(this.cursor);
        this.cursor.left();
        this.selection.resetTo(this.cursor);
        this.changeMade();
    }

    protected void left(boolean alt, boolean shift) {
    }

    protected void right(boolean alt, boolean shift) {
    }

    protected void home(boolean alt, boolean shift) {
    }

    protected void end(boolean alt, boolean shift) {
    }

    protected void pageDown(boolean shift, boolean ctrl) {
    }

    protected void pageUp(boolean shift, boolean ctrl) {
    }

    private String echoPassword(String password) {
        int length = password.length();
        String echoedPassword = "";
        for (int i = 0; i < length; ++i) {
            echoedPassword = echoedPassword + this.echoCharacter;
        }
        return echoedPassword;
    }

    public Size getMaximumSize() {
        int width = HPADDING + this.maxTextWidth + HPADDING;
        int height = style.getTextHeight() + VPADDING;
        height = Math.max(height, Toolkit.defaultFieldHeight());
        return new Size(width, height);
    }

    private void setMaxTextWidth(int noCharacters) {
        this.maxTextWidth = style.charWidth('o') * noCharacters;
    }

    protected void align() {
    }

    protected void drawHighlight(Canvas canvas, int maxWidth) {
    }

    protected void drawLines(Canvas canvas, Color color, int width) {
        int baseline = this.getBaseline();
        canvas.drawLine(HPADDING, baseline, HPADDING + width, baseline, color);
    }

    protected void drawText(Canvas canvas, Color textColor, int width) {
        String[] lines = this.textContent.getDisplayLines();
        if (lines.length > 1) {
            throw new NakedObjectException("Password field should contain a string that contains no line breaks; contains " + lines.length);
        }
        String chars = lines[0];
        if (chars == null) {
            throw new NakedObjectException();
        }
        if (chars.endsWith("\n")) {
            throw new NakedObjectException();
        }
        int baseline = this.getBaseline();
        String echoPassword = this.echoPassword(chars);
        if (this.hasFocus() && this.canChangeValue().isAllowed()) {
            int pos = style.stringWidth(echoPassword) - HPADDING;
            Color color = Toolkit.getColor("color.text.cursor");
            canvas.drawLine(pos, baseline + style.getDescent(), pos, baseline - style.getAscent(), color);
        }
        canvas.drawText(echoPassword, HPADDING, baseline, textColor, style);
    }
}

