/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.view.graphic;

import org.nakedobjects.metamodel.commons.lang.ToString;
import org.nakedobjects.plugins.dndviewer.Canvas;
import org.nakedobjects.plugins.dndviewer.Content;
import org.nakedobjects.plugins.dndviewer.Toolkit;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Bounds;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Image;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Location;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Size;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Text;
import org.nakedobjects.plugins.dndviewer.viewer.image.ImageFactory;

public class IconGraphic {
    private int baseline;
    protected final Content content;
    protected Image icon;
    protected final int iconHeight;
    private String lastIconName;

    public IconGraphic(View view, int height, int baseline) {
        this.content = view.getContent();
        this.iconHeight = height;
        this.baseline = baseline;
    }

    public IconGraphic(View view, int height) {
        this.content = view.getContent();
        this.iconHeight = height;
    }

    public IconGraphic(View view, Text style) {
        this.content = view.getContent();
        this.iconHeight = style.getTextHeight();
        this.baseline = style.getAscent();
    }

    public void draw(Canvas canvas, int x, int baseline) {
        Image icon;
        boolean y = true;
        if (Toolkit.debug) {
            canvas.drawDebugOutline(new Bounds(new Location(x, 1), this.getSize()), this.getBaseline(), Toolkit.getColor("color.debug.bounds.draw"));
        }
        if ((icon = this.icon()) == null) {
            canvas.drawSolidOval(x + 1, 1, this.iconHeight, this.iconHeight, Toolkit.getColor("color.primary3"));
        } else {
            canvas.drawImage(icon, x + 1, 1);
        }
    }

    public int getBaseline() {
        return this.baseline;
    }

    public Size getSize() {
        Image icon = this.icon();
        int iconWidth = icon == null ? this.iconHeight : icon.getWidth();
        return new Size(iconWidth + 2, this.iconHeight + 2);
    }

    protected Image icon() {
        String iconName = this.content.getIconName();
        if (this.icon != null && (iconName == null || iconName.equals(this.lastIconName))) {
            return this.icon;
        }
        this.lastIconName = iconName;
        if (iconName != null) {
            this.icon = ImageFactory.getInstance().loadIcon(iconName, this.iconHeight, null);
        }
        if (this.icon == null) {
            this.icon = this.content.getIconPicture(this.iconHeight);
        }
        if (this.icon == null) {
            this.icon = ImageFactory.getInstance().loadDefaultIcon(this.iconHeight, null);
        }
        return this.icon;
    }

    public String toString() {
        ToString str = new ToString((Object)this);
        str.append("baseline", this.baseline);
        str.append("icon", (Object)this.icon);
        return str.toString();
    }
}

