/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.view.text;

import org.apache.log4j.Logger;
import org.nakedobjects.plugins.dndviewer.viewer.view.text.TextBlockTarget;

class TextBlock {
    private static final Logger LOG = Logger.getLogger(TextBlock.class);
    private static final Logger UI_LOG = Logger.getLogger((String)("ui." + TextBlock.class.getName()));
    private final TextBlockTarget forField;
    private String text;
    private int[] lineBreaks;
    private boolean isFormatted;
    private int lineCount;
    private boolean canWrap;

    TextBlock(TextBlockTarget forField, String text, boolean canWrap) {
        this.forField = forField;
        this.text = text;
        this.isFormatted = false;
        this.canWrap = canWrap;
    }

    public String getLine(int line) {
        if (line < 0 || line > this.lineCount) {
            throw new IllegalArgumentException("line outside of block " + line);
        }
        this.format();
        int from = this.lineStart(line);
        int to = this.lineEnd(line);
        return this.text.substring(from, to);
    }

    public String getText() {
        return this.text;
    }

    public void deleteLeft(int line, int character) {
        int pos = this.pos(line, character);
        if (pos > 0) {
            this.text = this.text.substring(0, pos - 1) + this.text.substring(pos);
            this.isFormatted = false;
        }
    }

    public void delete(int fromLine, int fromCharacter, int toLine, int toCharacter) {
        this.format();
        int from = this.pos(fromLine, fromCharacter);
        int to = this.pos(toLine, toCharacter);
        this.text = this.text.substring(0, from) + this.text.substring(to);
        this.isFormatted = false;
    }

    public void deleteTo(int toLine, int toCharacter) {
        this.format();
        boolean from = false;
        int to = this.pos(toLine, toCharacter);
        this.text = this.text.substring(0, 0) + this.text.substring(to);
        this.isFormatted = false;
    }

    public void deleteFrom(int fromLine, int fromCharacter) {
        this.format();
        int from = this.pos(fromLine, fromCharacter);
        int to = this.text.length();
        this.text = this.text.substring(0, from) + this.text.substring(to);
        this.isFormatted = false;
    }

    public void deleteRight(int line, int character) {
        int pos = this.pos(line, character);
        if (pos < this.text.length()) {
            this.text = this.text.substring(0, pos) + this.text.substring(pos + 1);
            this.isFormatted = false;
        }
    }

    public int noLines() {
        this.format();
        return this.lineCount + 1;
    }

    private void breakAt(int breakAt) {
        this.lineBreaks[this.lineCount] = breakAt;
        ++this.lineCount;
    }

    private void format() {
        if (this.canWrap && !this.isFormatted) {
            this.lineBreaks = new int[100];
            this.lineCount = 0;
            int length = this.text.length();
            int lineWidth = 0;
            int breakAt = -1;
            for (int pos = 0; pos < length; ++pos) {
                char ch = this.text.charAt(pos);
                if (ch == '\n') {
                    throw new IllegalStateException("Block must not contain newline characters");
                }
                if ((lineWidth += this.forField.getText().charWidth(ch)) > this.forField.getMaxFieldWidth()) {
                    breakAt = breakAt == -1 ? pos - 1 : breakAt;
                    this.breakAt(breakAt);
                    lineWidth = this.forField.getText().stringWidth(this.text.substring(breakAt - 1, pos + 1));
                    breakAt = -1;
                    continue;
                }
                if (ch != ' ') continue;
                breakAt = pos + 1;
            }
            this.isFormatted = true;
        }
    }

    public void insert(int line, int character, String characters) {
        if (characters.indexOf(10) >= 0) {
            throw new IllegalArgumentException("Insert characters cannot contain newline");
        }
        int pos = this.pos(line, character);
        this.text = this.text.substring(0, pos) + characters + this.text.substring(pos);
        this.isFormatted = false;
    }

    private int pos(int line, int character) {
        int pos = this.lineStart(line);
        LOG.debug((Object)("position " + (pos += character)));
        return pos;
    }

    private int lineStart(int line) {
        int pos = line == 0 ? 0 : this.lineBreaks[line - 1];
        UI_LOG.debug((Object)("line " + line + " starts at " + pos));
        return pos;
    }

    private int lineEnd(int line) {
        int pos = line >= this.lineCount ? this.text.length() : this.lineBreaks[line];
        UI_LOG.debug((Object)("line " + line + " ends at " + pos));
        return pos;
    }

    public TextBlock splitAt(int line, int character) {
        this.format();
        int pos = this.pos(line, character);
        TextBlock newBlock = new TextBlock(this.forField, this.text.substring(pos), this.canWrap);
        this.text = this.text.substring(0, pos);
        this.isFormatted = false;
        return newBlock;
    }

    public void setCanWrap(boolean canWrap) {
        this.canWrap = canWrap;
    }

    public String toString() {
        StringBuffer content = new StringBuffer();
        content.append("TextBlock [");
        content.append("formatted=");
        content.append(this.isFormatted);
        content.append(",lines=");
        content.append(this.lineCount);
        content.append(",text=");
        content.append(this.text);
        content.append(",breaks=");
        if (this.lineBreaks == null) {
            content.append("none");
        } else {
            for (int i = 0; i < this.lineBreaks.length; ++i) {
                content.append(i == 0 ? "" : ",");
                content.append(this.lineBreaks[i]);
            }
        }
        content.append("]");
        return content.toString();
    }

    public void join(TextBlock textBlock) {
        this.text = this.text + textBlock.text;
    }
}

