package org.nakedobjects.plugins.dnd.viewer.action;

import org.nakedobjects.metamodel.consent.Consent;
import org.nakedobjects.metamodel.consent.Veto;
import org.nakedobjects.metamodel.spec.feature.NakedObjectActionType;
import org.nakedobjects.plugins.dnd.Canvas;
import org.nakedobjects.plugins.dnd.ColorsAndFonts;
import org.nakedobjects.plugins.dnd.Toolkit;
import org.nakedobjects.plugins.dnd.UserAction;
import org.nakedobjects.plugins.dnd.View;
import org.nakedobjects.plugins.dnd.Workspace;
import org.nakedobjects.plugins.dnd.viewer.drawing.Location;


public class ResizeWindowControl extends WindowControl {

    public ResizeWindowControl(final View target) {
        super(new UserAction() {

            public Consent disabled(final View view) {
                return Veto.DEFAULT;
            }

            public void execute(final Workspace workspace, final View view, final Location at) {}

            public String getDescription(final View view) {
                return "";
            }

            public String getHelp(final View view) {
                return "";
            }

            public NakedObjectActionType getType() {
                return USER;
            }

            public String getName(final View view) {
                return "Resize";
            }
        }, target);

    }

    @Override
    public void draw(final Canvas canvas) {
        final int x = 0;
        final int y = 0;

        canvas.drawRectangle(x + 1, y + 1, WIDTH - 1, HEIGHT - 1, Toolkit.getColor(ColorsAndFonts.COLOR_WHITE));
        canvas.drawRectangle(x, y, WIDTH - 1, HEIGHT - 1, Toolkit.getColor(ColorsAndFonts.COLOR_SECONDARY1));
        canvas.drawRectangle(x + 3, y + 2, 8, 8, Toolkit.getColor(ColorsAndFonts.COLOR_SECONDARY2));
        canvas.drawLine(x + 3, y + 3, x + 10, y + 3, Toolkit.getColor(ColorsAndFonts.COLOR_SECONDARY2));
    }
}
// Copyright (c) Naked Objects Group Ltd.
