package org.nakedobjects.plugins.dnd.viewer.view.simple;

import org.nakedobjects.plugins.dnd.CompositeViewSpecification;
import org.nakedobjects.plugins.dnd.Content;
import org.nakedobjects.plugins.dnd.ViewAxis;
import org.nakedobjects.plugins.dnd.ViewBuilder;
import org.nakedobjects.plugins.dnd.viewer.drawing.Size;


public class CompositeViewBuilder extends AbstractCompositeView {
    private final ViewBuilder builder;

    public CompositeViewBuilder(final Content content, final CompositeViewSpecification specification, final ViewAxis axis) {
        super(content, specification, axis);
        builder = specification.getSubviewBuilder();
    }

    @Override
    public Size getMaximumSize() {
        final Size size = builder.getRequiredSize(this);
        size.extend(getPadding());
        size.ensureHeight(1);
        return size;
    }
    
    protected void buildView() {
            builder.build(getView());
    }

    protected void doLayout(Size maximumSize) {
            builder.layout(getView(), new Size(maximumSize));
    }
}
// Copyright (c) Naked Objects Group Ltd.
