/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd.viewer;

import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.ResolveState;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.config.internal.PropertiesConfiguration;
import org.nakedobjects.metamodel.specloader.SpecificationLoader;
import org.nakedobjects.plugins.dnd.Content;
import org.nakedobjects.plugins.dnd.DummyView;
import org.nakedobjects.plugins.dnd.DummyWorkspaceView;
import org.nakedobjects.plugins.dnd.viewer.ExposedViewUpdateNotifier;
import org.nakedobjects.plugins.dnd.viewer.content.RootObject;
import org.nakedobjects.runtime.authentication.AuthenticationManager;
import org.nakedobjects.runtime.authentication.standard.exploration.ExplorationSession;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.context.NakedObjectsContextStatic;
import org.nakedobjects.runtime.imageloader.TemplateImageLoader;
import org.nakedobjects.runtime.persistence.PersistenceSession;
import org.nakedobjects.runtime.persistence.PersistenceSessionFactory;
import org.nakedobjects.runtime.session.NakedObjectSessionFactory;
import org.nakedobjects.runtime.session.NakedObjectSessionFactoryDefault;
import org.nakedobjects.runtime.system.DeploymentType;
import org.nakedobjects.runtime.testsystem.TestProxyNakedObject;
import org.nakedobjects.runtime.testsystem.TestProxySystem;
import org.nakedobjects.runtime.transaction.NakedObjectTransaction;
import org.nakedobjects.runtime.transaction.NakedObjectTransactionManager;
import org.nakedobjects.runtime.userprofile.UserProfile;
import org.nakedobjects.runtime.userprofile.UserProfileLoader;

@RunWith(value=JMock.class)
public class ViewUpdateNotifierTest {
    private Mockery mockery = new JUnit4Mockery();
    private ExposedViewUpdateNotifier notifier;
    private TestProxyNakedObject object;
    protected TemplateImageLoader mockTemplateImageLoader;
    protected SpecificationLoader mockSpecificationLoader;
    private UserProfileLoader mockUserProfileLoader;
    protected PersistenceSessionFactory mockPersistenceSessionFactory;
    protected PersistenceSession mockPersistenceSession;
    protected NakedObjectTransactionManager mockTransactionManager;
    protected NakedObjectTransaction mockTransaction;
    protected AuthenticationManager mockAuthenticationManager;
    private List<Object> servicesList;

    @Before
    public void setUp() throws Exception {
        Logger.getRootLogger().setLevel(Level.OFF);
        this.servicesList = Collections.emptyList();
        this.mockTemplateImageLoader = (TemplateImageLoader)this.mockery.mock(TemplateImageLoader.class);
        this.mockSpecificationLoader = (SpecificationLoader)this.mockery.mock(SpecificationLoader.class);
        this.mockUserProfileLoader = (UserProfileLoader)this.mockery.mock(UserProfileLoader.class);
        this.mockPersistenceSessionFactory = (PersistenceSessionFactory)this.mockery.mock(PersistenceSessionFactory.class);
        this.mockPersistenceSession = (PersistenceSession)this.mockery.mock(PersistenceSession.class);
        this.mockTransactionManager = (NakedObjectTransactionManager)this.mockery.mock(NakedObjectTransactionManager.class);
        this.mockTransaction = (NakedObjectTransaction)this.mockery.mock(NakedObjectTransaction.class);
        this.mockAuthenticationManager = (AuthenticationManager)this.mockery.mock(AuthenticationManager.class);
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                this.ignoring(ViewUpdateNotifierTest.this.mockTemplateImageLoader);
                this.ignoring(ViewUpdateNotifierTest.this.mockSpecificationLoader);
                this.ignoring(ViewUpdateNotifierTest.this.mockAuthenticationManager);
                ((UserProfileLoader)this.one(ViewUpdateNotifierTest.this.mockUserProfileLoader)).getProfile((AuthenticationSession)this.with(1.any(AuthenticationSession.class)));
                this.will(1.returnValue((Object)new UserProfile()));
                this.ignoring(ViewUpdateNotifierTest.this.mockUserProfileLoader);
                ((PersistenceSessionFactory)this.allowing(ViewUpdateNotifierTest.this.mockPersistenceSessionFactory)).createPersistenceSession();
                this.will(1.returnValue((Object)ViewUpdateNotifierTest.this.mockPersistenceSession));
                this.ignoring(ViewUpdateNotifierTest.this.mockPersistenceSessionFactory);
                ((PersistenceSession)this.allowing(ViewUpdateNotifierTest.this.mockPersistenceSession)).getTransactionManager();
                this.will(1.returnValue((Object)ViewUpdateNotifierTest.this.mockTransactionManager));
                this.ignoring(ViewUpdateNotifierTest.this.mockPersistenceSession);
                ((NakedObjectTransactionManager)this.allowing(ViewUpdateNotifierTest.this.mockTransactionManager)).getTransaction();
                this.will(1.returnValue((Object)ViewUpdateNotifierTest.this.mockTransaction));
                this.ignoring(ViewUpdateNotifierTest.this.mockTransaction);
            }
        });
        NakedObjectSessionFactoryDefault sessionFactory = new NakedObjectSessionFactoryDefault(DeploymentType.EXPLORATION, (NakedObjectConfiguration)new PropertiesConfiguration(), this.mockTemplateImageLoader, this.mockSpecificationLoader, this.mockAuthenticationManager, this.mockUserProfileLoader, this.mockPersistenceSessionFactory, this.servicesList);
        sessionFactory.init();
        NakedObjectsContextStatic.createRelaxedInstance((NakedObjectSessionFactory)sessionFactory);
        NakedObjectsContext.openSession((AuthenticationSession)new ExplorationSession());
        this.notifier = new ExposedViewUpdateNotifier();
        this.object = new TestProxyNakedObject();
    }

    @After
    public void tearDown() {
        NakedObjectsContext.closeSession();
    }

    private DummyView createView(NakedObject object) {
        DummyView view = new DummyView();
        view.setupContent((Content)new RootObject(object));
        return view;
    }

    @Test
    public void testAddViewWithNonObjectContent() {
        DummyView view = this.createView(null);
        this.notifier.add(view);
        this.notifier.assertEmpty();
    }

    @Test
    public void testAddViewWithObjectContent() {
        DummyView view = this.addViewForObject();
        this.notifier.assertContainsViewForObject(view, (NakedObject)this.object);
    }

    private DummyView addViewForObject() {
        DummyView view = this.createView((NakedObject)this.object);
        this.notifier.add(view);
        return view;
    }

    @Test
    public void testAddViewIsIgnoredAfterFirstCall() {
        DummyView view = this.addViewForObject();
        try {
            this.notifier.add(view);
            Assert.fail();
        }
        catch (NakedObjectException nakedObjectException) {
            // empty catch block
        }
    }

    @Test
    public void testDebug() throws Exception {
        this.addViewForObject();
        DebugString debugString = new DebugString();
        this.notifier.debugData(debugString);
        Assert.assertNotNull((Object)debugString.toString());
    }

    @Test
    public void testRemoveView() {
        Vector<DummyView> vector = new Vector<DummyView>();
        DummyView view = this.createView((NakedObject)this.object);
        vector.addElement(view);
        this.notifier.setupViewsForObject((NakedObject)this.object, vector);
        this.notifier.remove(view);
        this.notifier.assertEmpty();
    }

    @Test
    public void testViewDirty() {
        TestProxySystem testProxySystem = new TestProxySystem();
        testProxySystem.init();
        this.object.setupResolveState(ResolveState.RESOLVED);
        Vector<DummyView> vector = new Vector<DummyView>();
        DummyView view1 = this.createView((NakedObject)this.object);
        vector.addElement(view1);
        DummyView view2 = this.createView((NakedObject)this.object);
        vector.addElement(view2);
        this.notifier.setupViewsForObject((NakedObject)this.object, vector);
        this.notifier.invalidateViewsForChangedObjects();
        Assert.assertEquals((long)0L, (long)view1.invalidateContent);
        Assert.assertEquals((long)0L, (long)view2.invalidateContent);
        NakedObjectsContext.getUpdateNotifier().addChangedObject((NakedObject)this.object);
        this.notifier.invalidateViewsForChangedObjects();
        Assert.assertEquals((long)1L, (long)view1.invalidateContent);
        Assert.assertEquals((long)1L, (long)view2.invalidateContent);
    }

    @Test
    public void testDisposedViewsRemoved() {
        TestProxySystem testProxySystem = new TestProxySystem();
        testProxySystem.init();
        DummyWorkspaceView workspace = new DummyWorkspaceView();
        Vector<DummyView> vector = new Vector<DummyView>();
        DummyView view1 = this.createView((NakedObject)this.object);
        view1.setParent(workspace);
        workspace.addView(view1);
        vector.addElement(view1);
        DummyView view2 = this.createView((NakedObject)this.object);
        view2.setParent(workspace);
        workspace.addView(view2);
        vector.addElement(view2);
        this.notifier.setupViewsForObject((NakedObject)this.object, vector);
        this.notifier.invalidateViewsForChangedObjects();
        Assert.assertEquals((long)0L, (long)view1.invalidateContent);
        Assert.assertEquals((long)0L, (long)view2.invalidateContent);
        NakedObjectsContext.getUpdateNotifier().addDisposedObject((NakedObject)this.object);
        this.notifier.removeViewsForDisposedObjects();
        Assert.assertEquals((long)0L, (long)workspace.getSubviews().length);
    }
}

