/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd.viewer.content;

import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nakedobjects.metamodel.adapter.InvalidEntryException;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.commons.filters.Filter;
import org.nakedobjects.metamodel.consent.Allow;
import org.nakedobjects.metamodel.consent.Veto;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.object.parseable.ParseableFacet;
import org.nakedobjects.metamodel.interactions.ValidatingInteractionAdvisor;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.feature.OneToOneAssociation;
import org.nakedobjects.plugins.dnd.viewer.content.TextParseableFieldImpl;
import org.nakedobjects.runtime.testsystem.TestProxySystem;

@RunWith(value=JMock.class)
public class TextParseableField_ParseTextEntry {
    private final Mockery context = new JUnit4Mockery();
    private NakedObject mockParent;
    private NakedObject mockChild;
    private OneToOneAssociation mockOtoa;
    private NakedObjectSpecification mockOtoaSpec;
    private ParseableFacet mockParseableFacet;
    private NakedObject mockParsedText;
    private TextParseableFieldImpl fieldImpl;
    private ValidatingInteractionAdvisor mockValidatingInteractionAdvisorFacet;
    private TestProxySystem system;

    @Before
    public void setUp() throws Exception {
        this.system = new TestProxySystem();
        this.system.init();
        this.mockParent = (NakedObject)this.context.mock(NakedObject.class, "parent");
        this.mockChild = (NakedObject)this.context.mock(NakedObject.class, "child");
        this.mockOtoa = (OneToOneAssociation)this.context.mock(OneToOneAssociation.class);
        this.mockOtoaSpec = (NakedObjectSpecification)this.context.mock(NakedObjectSpecification.class);
        this.mockParseableFacet = (ParseableFacet)this.context.mock(ParseableFacet.class);
        this.mockParsedText = (NakedObject)this.context.mock(NakedObject.class, "parsedText");
        this.mockValidatingInteractionAdvisorFacet = (ValidatingInteractionAdvisor)this.context.mock(ValidatingInteractionAdvisor.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((OneToOneAssociation)this.allowing(TextParseableField_ParseTextEntry.this.mockOtoa)).getIdentifier();
                ((OneToOneAssociation)this.allowing(TextParseableField_ParseTextEntry.this.mockOtoa)).getSpecification();
                this.will(1.returnValue((Object)TextParseableField_ParseTextEntry.this.mockOtoaSpec));
                ((NakedObjectSpecification)this.one(TextParseableField_ParseTextEntry.this.mockOtoaSpec)).getFacet(ParseableFacet.class);
                this.will(1.returnValue((Object)TextParseableField_ParseTextEntry.this.mockParseableFacet));
            }
        });
        this.fieldImpl = new TextParseableFieldImpl(this.mockParent, this.mockChild, this.mockOtoa);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void parsedTextIsValidForSpecAndCorrespondingObjectValidAsAssociation() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ParseableFacet)this.one(TextParseableField_ParseTextEntry.this.mockParseableFacet)).parseTextEntry(TextParseableField_ParseTextEntry.this.mockChild, "foo");
                this.will(2.returnValue((Object)TextParseableField_ParseTextEntry.this.mockParsedText));
                ((OneToOneAssociation)this.atLeast(1).of((Object)TextParseableField_ParseTextEntry.this.mockOtoa)).isAssociationValid(TextParseableField_ParseTextEntry.this.mockParent, TextParseableField_ParseTextEntry.this.mockParsedText);
                this.will(2.returnValue((Object)Allow.DEFAULT));
                ((OneToOneAssociation)this.one(TextParseableField_ParseTextEntry.this.mockOtoa)).isMandatory();
            }
        });
        this.fieldImpl.parseTextEntry("foo");
    }

    @Test(expected=InvalidEntryException.class)
    public void parsedTextIsNullWhenMandatoryThrowsException() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ParseableFacet)this.one(TextParseableField_ParseTextEntry.this.mockParseableFacet)).parseTextEntry(TextParseableField_ParseTextEntry.this.mockChild, "foo");
                this.will(3.returnValue(null));
                ((OneToOneAssociation)this.atLeast(1).of((Object)TextParseableField_ParseTextEntry.this.mockOtoa)).isAssociationValid(TextParseableField_ParseTextEntry.this.mockParent, null);
                this.will(3.returnValue((Object)Allow.DEFAULT));
                ((OneToOneAssociation)this.one(TextParseableField_ParseTextEntry.this.mockOtoa)).isMandatory();
                this.will(3.returnValue((Object)true));
            }
        });
        this.fieldImpl.parseTextEntry("foo");
    }

    @Test
    public void parsedTextIsValidAccordingToSpecificationFacet() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ParseableFacet)this.one(TextParseableField_ParseTextEntry.this.mockParseableFacet)).parseTextEntry(TextParseableField_ParseTextEntry.this.mockChild, "foo");
                this.will(4.returnValue((Object)TextParseableField_ParseTextEntry.this.mockParsedText));
                ((OneToOneAssociation)this.atLeast(1).of((Object)TextParseableField_ParseTextEntry.this.mockOtoa)).isAssociationValid(TextParseableField_ParseTextEntry.this.mockParent, TextParseableField_ParseTextEntry.this.mockParsedText);
                this.will(4.returnValue((Object)Allow.DEFAULT));
                ((OneToOneAssociation)this.allowing(TextParseableField_ParseTextEntry.this.mockOtoa)).isMandatory();
                this.will(4.returnValue((Object)true));
            }
        });
        this.fieldImpl.parseTextEntry("foo");
    }

    @Test(expected=InvalidEntryException.class)
    public void parsedTextIsInvalidAccordingToSpecification() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ParseableFacet)this.allowing(TextParseableField_ParseTextEntry.this.mockParseableFacet)).parseTextEntry(TextParseableField_ParseTextEntry.this.mockChild, "foo");
                this.will(5.returnValue((Object)TextParseableField_ParseTextEntry.this.mockParsedText));
                ((OneToOneAssociation)this.atLeast(1).of((Object)TextParseableField_ParseTextEntry.this.mockOtoa)).isAssociationValid(TextParseableField_ParseTextEntry.this.mockParent, TextParseableField_ParseTextEntry.this.mockParsedText);
                this.will(5.returnValue((Object)Veto.DEFAULT));
                ((OneToOneAssociation)this.allowing(TextParseableField_ParseTextEntry.this.mockOtoa)).isMandatory();
                this.will(5.returnValue((Object)true));
            }
        });
        this.fieldImpl.parseTextEntry("foo");
    }

    @Test(expected=IllegalArgumentException.class)
    public void parsedTextIsInvalidAccordingToAssociation() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ParseableFacet)this.allowing(TextParseableField_ParseTextEntry.this.mockParseableFacet)).parseTextEntry(TextParseableField_ParseTextEntry.this.mockChild, "foo");
                this.will(6.returnValue((Object)TextParseableField_ParseTextEntry.this.mockParsedText));
                ((OneToOneAssociation)this.allowing(TextParseableField_ParseTextEntry.this.mockOtoa)).getFacets((Filter)this.with(6.any(Filter.class)));
                this.will(6.returnValue((Object)new Facet[0]));
                ((OneToOneAssociation)this.one(TextParseableField_ParseTextEntry.this.mockOtoa)).isAssociationValid(TextParseableField_ParseTextEntry.this.mockParent, TextParseableField_ParseTextEntry.this.mockParsedText);
                this.will(6.returnValue((Object)Veto.DEFAULT));
                ((OneToOneAssociation)this.allowing(TextParseableField_ParseTextEntry.this.mockOtoa)).isMandatory();
                this.allowing(6.returnValue((Object)true));
            }
        });
        this.fieldImpl.parseTextEntry("foo");
    }
}

