/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd.viewer.drawing;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.nakedobjects.plugins.dnd.viewer.drawing.Bounds;
import org.nakedobjects.plugins.dnd.viewer.drawing.Location;
import org.nakedobjects.plugins.dnd.viewer.drawing.Padding;
import org.nakedobjects.plugins.dnd.viewer.drawing.Size;

public class BoundsTest
extends TestCase {
    private Bounds b;

    public static void main(String[] args) {
        TestRunner.run(BoundsTest.class);
    }

    protected void setUp() throws Exception {
        Logger.getRootLogger().setLevel(Level.OFF);
        this.b = new Bounds(5, 10, 10, 20);
    }

    public void testContains() {
        BoundsTest.assertTrue((boolean)this.b.contains(new Location(8, 15)));
        BoundsTest.assertTrue((boolean)this.b.contains(new Location(5, 10)));
        BoundsTest.assertFalse((boolean)this.b.contains(new Location(4, 10)));
        BoundsTest.assertFalse((boolean)this.b.contains(new Location(15, 10)));
        BoundsTest.assertTrue((boolean)this.b.contains(new Location(10, 29)));
    }

    public void testNotEquals() {
        Bounds c = new Bounds(0, 10, 10, 20);
        BoundsTest.assertFalse((boolean)c.equals((Object)this.b));
        c = new Bounds(5, 0, 10, 20);
        BoundsTest.assertFalse((boolean)c.equals((Object)this.b));
        c = new Bounds(5, 10, 0, 20);
        BoundsTest.assertFalse((boolean)c.equals((Object)this.b));
        c = new Bounds(5, 10, 10, 0);
        BoundsTest.assertFalse((boolean)c.equals((Object)this.b));
    }

    public void testEquals() {
        Bounds c = new Bounds(5, 10, 10, 20);
        BoundsTest.assertTrue((boolean)c.equals((Object)this.b));
        BoundsTest.assertTrue((boolean)this.b.equals((Object)c));
    }

    public void testContracSize() {
        this.b.contract(new Size(5, 12));
        BoundsTest.assertEquals((int)5, (int)this.b.getWidth());
        BoundsTest.assertEquals((int)8, (int)this.b.getHeight());
    }

    public void testContractHeight() {
        this.b.contractHeight(12);
        BoundsTest.assertEquals((int)8, (int)this.b.getHeight());
    }

    public void testContractPadding() {
        this.b.contract(new Padding(2, 4, 1, 3));
        BoundsTest.assertEquals((int)3, (int)this.b.getWidth());
        BoundsTest.assertEquals((int)17, (int)this.b.getHeight());
        BoundsTest.assertEquals((int)9, (int)this.b.getX());
        BoundsTest.assertEquals((int)12, (int)this.b.getY());
    }

    public void testContracWidth() {
        this.b.contractWidth(5);
        BoundsTest.assertEquals((int)5, (int)this.b.getWidth());
    }

    public void testCopyBounds() {
        Bounds c = new Bounds();
        c.setBounds(this.b);
        BoundsTest.assertEquals((int)5, (int)this.b.getX());
        BoundsTest.assertEquals((int)10, (int)this.b.getY());
        BoundsTest.assertEquals((int)10, (int)this.b.getWidth());
        BoundsTest.assertEquals((int)20, (int)this.b.getHeight());
    }

    public void testDefaultBounds() {
        Bounds b = new Bounds();
        BoundsTest.assertEquals((int)0, (int)b.getX());
        BoundsTest.assertEquals((int)0, (int)b.getY());
        BoundsTest.assertEquals((int)0, (int)b.getWidth());
        BoundsTest.assertEquals((int)0, (int)b.getHeight());
    }

    public void testDownLeftIntersects() {
        Bounds c = new Bounds(this.b);
        c.translate(-5, -5);
        BoundsTest.assertTrue((boolean)this.b.intersects(c));
        c.translate(-this.b.getWidth(), 0);
        BoundsTest.assertFalse((boolean)this.b.intersects(c));
    }

    public void testEnclosingUnion() {
        Bounds c = new Bounds(10, 20, 5, 5);
        Bounds u = new Bounds(this.b);
        u.union(c);
        BoundsTest.assertEquals((Object)this.b, (Object)u);
    }

    public void testExplicitBounds() {
        BoundsTest.assertEquals((int)5, (int)this.b.getX());
        BoundsTest.assertEquals((int)10, (int)this.b.getY());
        BoundsTest.assertEquals((int)10, (int)this.b.getWidth());
        BoundsTest.assertEquals((int)20, (int)this.b.getHeight());
        Bounds b1 = new Bounds(this.b);
        BoundsTest.assertEquals((int)5, (int)b1.getX());
        BoundsTest.assertEquals((int)10, (int)b1.getY());
        BoundsTest.assertEquals((int)10, (int)b1.getWidth());
        BoundsTest.assertEquals((int)20, (int)b1.getHeight());
        Bounds b2 = new Bounds(new Location(10, 20), new Size(8, 16));
        BoundsTest.assertEquals((int)10, (int)b2.getX());
        BoundsTest.assertEquals((int)20, (int)b2.getY());
        BoundsTest.assertEquals((int)8, (int)b2.getWidth());
        BoundsTest.assertEquals((int)16, (int)b2.getHeight());
        Bounds b3 = new Bounds(new Size(5, 10));
        BoundsTest.assertEquals((int)0, (int)b3.getX());
        BoundsTest.assertEquals((int)0, (int)b3.getY());
        BoundsTest.assertEquals((int)5, (int)b3.getWidth());
        BoundsTest.assertEquals((int)10, (int)b3.getHeight());
    }

    public void testFarPoint() {
        BoundsTest.assertEquals((int)5, (int)this.b.getX());
        BoundsTest.assertEquals((int)14, (int)this.b.getX2());
        BoundsTest.assertEquals((int)10, (int)this.b.getY());
        BoundsTest.assertEquals((int)29, (int)this.b.getY2());
    }

    public void testgrow() {
        this.b.extend(10, 5);
        BoundsTest.assertEquals((int)5, (int)this.b.getX());
        BoundsTest.assertEquals((int)10, (int)this.b.getY());
        BoundsTest.assertEquals((int)20, (int)this.b.getWidth());
        BoundsTest.assertEquals((int)25, (int)this.b.getHeight());
    }

    public void testLimitBoundsWhenTooTall() {
        Bounds b2 = new Bounds(10, 0, 4, 30);
        BoundsTest.assertTrue((boolean)this.b.limitBounds(b2));
        BoundsTest.assertEquals((Object)new Bounds(10, 10, 4, 20), (Object)b2);
    }

    public void testLimitBoundsWhenTooWide() {
        Bounds b2 = new Bounds(0, 12, 20, 5);
        BoundsTest.assertTrue((boolean)this.b.limitBounds(b2));
        BoundsTest.assertEquals((Object)new Bounds(5, 12, 10, 5), (Object)b2);
    }

    public void testLimitBoundsWithHorizontalOverlap() {
        Bounds b2 = new Bounds(10, 12, 10, 5);
        BoundsTest.assertTrue((boolean)this.b.limitBounds(b2));
        BoundsTest.assertEquals((Object)new Bounds(5, 12, 10, 5), (Object)b2);
    }

    public void testLimitBoundsWithNoOverlap() {
        Bounds b2 = new Bounds(7, 12, 5, 5);
        BoundsTest.assertFalse((boolean)this.b.limitBounds(b2));
        BoundsTest.assertEquals((Object)new Bounds(7, 12, 5, 5), (Object)b2);
    }

    public void testLimitBoundsWithVerticalOverlap() {
        Bounds b2 = new Bounds(5, 20, 5, 20);
        BoundsTest.assertTrue((boolean)this.b.limitBounds(b2));
        BoundsTest.assertEquals((Object)new Bounds(5, 10, 5, 20), (Object)b2);
    }

    public void testNonOverlappingUnion() {
        Bounds c = new Bounds(20, 40, 10, 20);
        Bounds u = new Bounds(this.b);
        u.union(c);
        BoundsTest.assertEquals((Object)new Bounds(5, 10, 25, 50), (Object)u);
    }

    public void testOverlappingIntersects() {
        Bounds c = new Bounds(this.b);
        c.translate(-5, -5);
        c.extend(10, 10);
        BoundsTest.assertTrue((boolean)this.b.intersects(c));
        c = new Bounds(this.b);
        c.translate(5, 5);
        c.extend(-10, -10);
        BoundsTest.assertTrue((boolean)this.b.intersects(c));
    }

    public void testOverlappingUnion() {
        Bounds c = new Bounds(3, 5, 10, 10);
        Bounds u = new Bounds(this.b);
        u.union(c);
        BoundsTest.assertEquals((Object)new Bounds(3, 5, 12, 25), (Object)u);
    }

    public void testTranslate() {
        this.b.translate(10, 5);
        BoundsTest.assertEquals((int)15, (int)this.b.getX());
        BoundsTest.assertEquals((int)15, (int)this.b.getY());
        BoundsTest.assertEquals((int)10, (int)this.b.getWidth());
        BoundsTest.assertEquals((int)20, (int)this.b.getHeight());
    }

    public void testUpRightIntersects() {
        Bounds c = new Bounds(this.b);
        c.translate(5, 5);
        BoundsTest.assertTrue((boolean)this.b.intersects(c));
        c.translate(this.b.getWidth(), 0);
        BoundsTest.assertFalse((boolean)this.b.intersects(c));
    }

    public void testXNoOverlapToLeft() {
        Bounds c = new Bounds(1, 15, 4, 0);
        BoundsTest.assertFalse((boolean)this.b.intersects(c));
    }

    public void testXNoOverlapToRight() {
        Bounds c = new Bounds(15, 15, 5, 0);
        BoundsTest.assertFalse((boolean)this.b.intersects(c));
    }

    public void testXOverlapInCenter() {
        Bounds c = new Bounds(6, 15, 2, 0);
        BoundsTest.assertTrue((boolean)this.b.intersects(c));
    }

    public void testXOverlapToLeft() {
        Bounds c = new Bounds(1, 15, 6, 0);
        BoundsTest.assertTrue((boolean)this.b.intersects(c));
    }

    public void testXOverlapToRight() {
        Bounds c = new Bounds(14, 15, 5, 0);
        BoundsTest.assertTrue((boolean)this.b.intersects(c));
    }

    public void testYOverlapToTop() {
        Bounds c = new Bounds(10, 29, 0, 5);
        BoundsTest.assertTrue((boolean)this.b.intersects(c));
    }
}

