/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd.viewer.drawing;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.nakedobjects.plugins.dnd.viewer.drawing.Padding;
import org.nakedobjects.plugins.dnd.viewer.drawing.Size;

public class SizeTest
extends TestCase {
    private Size s;

    public static void main(String[] args) {
        TestRunner.run(SizeTest.class);
    }

    protected void setUp() throws Exception {
        Logger.getRootLogger().setLevel(Level.OFF);
        this.s = new Size(10, 20);
    }

    public void testCopy() {
        Size m = new Size(this.s);
        SizeTest.assertTrue((this.s != m ? 1 : 0) != 0);
        SizeTest.assertEquals((Object)this.s, (Object)m);
    }

    public void testEnsure() {
        this.s.ensureWidth(18);
        SizeTest.assertEquals((Object)new Size(18, 20), (Object)this.s);
        this.s.ensureWidth(12);
        SizeTest.assertEquals((Object)new Size(18, 20), (Object)this.s);
        this.s.ensureHeight(16);
        SizeTest.assertEquals((Object)new Size(18, 20), (Object)this.s);
        this.s.ensureHeight(26);
        SizeTest.assertEquals((Object)new Size(18, 26), (Object)this.s);
    }

    public void addPadding() {
        this.s.extend(new Padding(1, 2, 3, 4));
        SizeTest.assertEquals((Object)new Size(14, 26), (Object)this.s);
    }

    public void testExtend() {
        this.s.extendWidth(8);
        SizeTest.assertEquals((Object)new Size(18, 20), (Object)this.s);
        this.s.extendHeight(6);
        SizeTest.assertEquals((Object)new Size(18, 26), (Object)this.s);
        this.s.extend(new Size(3, 5));
        SizeTest.assertEquals((Object)new Size(21, 31), (Object)this.s);
        this.s.extend(5, 3);
        SizeTest.assertEquals((Object)new Size(26, 34), (Object)this.s);
    }
}

