/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd.viewer.view;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.nakedobjects.plugins.dnd.Content;
import org.nakedobjects.plugins.dnd.NullContent;
import org.nakedobjects.plugins.dnd.ViewAreaType;
import org.nakedobjects.plugins.dnd.viewer.drawing.Bounds;
import org.nakedobjects.plugins.dnd.viewer.drawing.Location;
import org.nakedobjects.plugins.dnd.viewer.drawing.Padding;
import org.nakedobjects.plugins.dnd.viewer.drawing.Size;
import org.nakedobjects.plugins.dnd.viewer.view.simple.AbstractView;

public class AbstractViewTest
extends TestCase {
    private AbstractView av;

    public static void main(String[] args) {
        TestRunner.run(AbstractViewTest.class);
    }

    protected void setUp() throws Exception {
        this.av = new AbstractView((Content)new NullContent(), null, null){};
        super.setUp();
    }

    public void testBounds() {
        AbstractViewTest.assertEquals((Object)new Location(), (Object)this.av.getLocation());
        AbstractViewTest.assertEquals((Object)new Size(), (Object)this.av.getSize());
        AbstractViewTest.assertEquals((Object)new Bounds(), (Object)this.av.getBounds());
        this.av.setLocation(new Location(10, 20));
        AbstractViewTest.assertEquals((Object)new Location(10, 20), (Object)this.av.getLocation());
        AbstractViewTest.assertEquals((Object)new Size(), (Object)this.av.getSize());
        AbstractViewTest.assertEquals((Object)new Bounds(10, 20, 0, 0), (Object)this.av.getBounds());
        this.av.setSize(new Size(30, 40));
        AbstractViewTest.assertEquals((Object)new Location(10, 20), (Object)this.av.getLocation());
        AbstractViewTest.assertEquals((Object)new Size(30, 40), (Object)this.av.getSize());
        AbstractViewTest.assertEquals((Object)new Bounds(10, 20, 30, 40), (Object)this.av.getBounds());
        this.av.setBounds(new Bounds(new Location(50, 60), new Size(70, 80)));
        AbstractViewTest.assertEquals((Object)new Location(50, 60), (Object)this.av.getLocation());
        AbstractViewTest.assertEquals((Object)new Size(70, 80), (Object)this.av.getSize());
        AbstractViewTest.assertEquals((Object)new Bounds(50, 60, 70, 80), (Object)this.av.getBounds());
    }

    public void testPadding() {
        AbstractViewTest.assertEquals((Object)new Padding(0, 0, 0, 0), (Object)this.av.getPadding());
    }

    public void testViewAreaType() {
        Location loc = new Location(10, 10);
        AbstractViewTest.assertEquals((Object)ViewAreaType.CONTENT, (Object)this.av.viewAreaType(loc));
    }
}

