/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd.viewer.view.text;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.nakedobjects.plugins.dnd.viewer.view.text.CursorPosition;
import org.nakedobjects.plugins.dnd.viewer.view.text.TextContent;
import org.nakedobjects.plugins.dnd.viewer.view.text.TextFieldContentStub;

public class CursorPositionTest
extends TestCase {
    private CursorPosition cursor;

    public static void main(String[] args) {
        TestRunner.run(CursorPositionTest.class);
    }

    private void assertPosition(int line, int character, CursorPosition cursor) {
        CursorPositionTest.assertEquals((int)line, (int)cursor.getLine());
        CursorPositionTest.assertEquals((int)character, (int)cursor.getCharacter());
    }

    protected void setUp() throws Exception {
        TextFieldContentStub stub = new TextFieldContentStub();
        this.cursor = new CursorPosition((TextContent)stub, 12, 3);
        String text = stub.getText(1);
        CursorPositionTest.assertEquals((int)35, (int)text.length());
        CursorPositionTest.assertEquals((String)"Now ", (String)text.substring(0, 4));
        CursorPositionTest.assertEquals((String)"is ", (String)text.substring(4, 7));
        CursorPositionTest.assertEquals((String)"the ", (String)text.substring(7, 11));
        CursorPositionTest.assertEquals((String)"winter ", (String)text.substring(11, 18));
        CursorPositionTest.assertEquals((String)"of ", (String)text.substring(18, 21));
        CursorPositionTest.assertEquals((String)"our ", (String)text.substring(21, 25));
        CursorPositionTest.assertEquals((String)"discontent", (String)text.substring(25, 35));
    }

    public void testBottom() {
        this.cursor.bottom();
        this.assertPosition(15, 35, this.cursor);
    }

    public void testCopy() {
        CursorPosition copy = new CursorPosition(null, 1, 1);
        copy.asFor(this.cursor);
        this.assertPosition(12, 3, copy);
    }

    public void testCreate() {
        this.assertPosition(12, 3, this.cursor);
    }

    public void testEnd() {
        this.cursor.end();
        this.assertPosition(12, 35, this.cursor);
    }

    public void testHome() {
        this.cursor.home();
        this.assertPosition(12, 0, this.cursor);
    }

    public void testLeft() {
        this.cursor.left();
        this.assertPosition(12, 2, this.cursor);
        this.cursor.left();
        this.assertPosition(12, 1, this.cursor);
        this.cursor.left();
        this.assertPosition(12, 0, this.cursor);
        this.cursor.left();
        this.assertPosition(11, 35, this.cursor);
    }

    public void testLeftPastHome() {
        this.cursor.home();
        this.cursor.left();
        this.assertPosition(11, 35, this.cursor);
    }

    public void testLeftPastTop() {
        this.cursor.top();
        this.cursor.left();
        this.assertPosition(0, 0, this.cursor);
    }

    public void testLineDown() {
        this.cursor.lineDown();
        this.assertPosition(13, 3, this.cursor);
    }

    public void testLineDownPastBottom() {
        this.cursor.bottom();
        this.cursor.lineDown();
        this.assertPosition(15, 35, this.cursor);
    }

    public void testLineUp() {
        this.cursor.lineUp();
        this.assertPosition(11, 3, this.cursor);
    }

    public void testLineUpPastTop() {
        this.cursor.top();
        this.cursor.lineUp();
        this.assertPosition(0, 0, this.cursor);
    }

    public void testPageDown() {
        this.cursor.pageDown();
        this.assertPosition(14, 3, this.cursor);
        this.cursor.pageDown();
        this.assertPosition(15, 3, this.cursor);
    }

    public void testRight() {
        this.cursor.right();
        this.assertPosition(12, 4, this.cursor);
        this.cursor.right();
        this.assertPosition(12, 5, this.cursor);
    }

    public void testRightPastEnd() {
        this.cursor.end();
        this.cursor.right();
        this.assertPosition(13, 1, this.cursor);
        this.cursor.right();
        this.assertPosition(13, 2, this.cursor);
    }

    public void testRightPastBottom() {
        this.cursor.bottom();
        this.cursor.right();
        this.assertPosition(15, 35, this.cursor);
    }

    public void testRightByNumber() {
        this.cursor.right(22);
        this.assertPosition(12, 25, this.cursor);
        this.cursor.right(100);
        this.assertPosition(15, 20, this.cursor);
        this.cursor.right(30);
        this.assertPosition(15, 20, this.cursor);
    }

    public void testWordLeft() {
        this.cursor.wordLeft();
        this.assertPosition(12, 0, this.cursor);
        this.cursor.wordLeft();
        this.assertPosition(11, 25, this.cursor);
    }

    public void testWordRight() {
        this.cursor.wordRight();
        this.assertPosition(12, 7, this.cursor);
        this.cursor.wordRight();
        this.assertPosition(12, 11, this.cursor);
        this.cursor.wordRight();
        this.assertPosition(12, 18, this.cursor);
        this.cursor.wordRight();
        this.assertPosition(12, 21, this.cursor);
        this.cursor.wordRight();
        this.assertPosition(12, 25, this.cursor);
        this.cursor.wordRight();
        this.assertPosition(13, 0, this.cursor);
        this.cursor.wordRight();
        this.assertPosition(13, 4, this.cursor);
        this.cursor.wordRight();
        this.assertPosition(13, 7, this.cursor);
    }

    public void testSamePostion() {
        CursorPosition other = new CursorPosition(null, 12, 15);
        CursorPositionTest.assertFalse((String)"different character", (boolean)this.cursor.samePosition(other));
        other = new CursorPosition(null, 7, 3);
        CursorPositionTest.assertFalse((String)"different line", (boolean)this.cursor.samePosition(other));
        other = new CursorPosition(null, 12, 3);
        CursorPositionTest.assertTrue((boolean)this.cursor.samePosition(other));
    }

    public void testPageUp() {
        this.cursor.pageUp();
        this.assertPosition(10, 3, this.cursor);
        this.cursor.pageUp();
        this.assertPosition(8, 3, this.cursor);
        this.cursor.pageUp();
        this.assertPosition(6, 3, this.cursor);
        this.cursor.pageUp();
        this.assertPosition(4, 3, this.cursor);
        this.cursor.pageUp();
        this.assertPosition(2, 3, this.cursor);
        this.cursor.pageUp();
        this.assertPosition(0, 3, this.cursor);
        this.cursor.pageUp();
        this.assertPosition(0, 3, this.cursor);
    }

    public void testIsBeforeWhereAtSamePosition() {
        CursorPosition other = new CursorPosition(null, 12, 3);
        CursorPositionTest.assertFalse((boolean)this.cursor.isBefore(other));
    }

    public void testIsBeforeWhere2CharacterAfter() {
        CursorPosition other = new CursorPosition(null, 12, 5);
        CursorPositionTest.assertTrue((boolean)this.cursor.isBefore(other));
    }

    public void testIsBeforeWhere2CharacterBefore() {
        CursorPosition other = new CursorPosition(null, 12, 1);
        CursorPositionTest.assertFalse((boolean)this.cursor.isBefore(other));
    }
}

