/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd.viewer.view.text;

import java.util.Collections;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.config.internal.PropertiesConfiguration;
import org.nakedobjects.metamodel.specloader.SpecificationLoader;
import org.nakedobjects.plugins.dnd.viewer.drawing.Location;
import org.nakedobjects.plugins.dnd.viewer.view.text.CursorPosition;
import org.nakedobjects.plugins.dnd.viewer.view.text.TextBlockTarget;
import org.nakedobjects.plugins.dnd.viewer.view.text.TextBlockTargetExample;
import org.nakedobjects.plugins.dnd.viewer.view.text.TextContent;
import org.nakedobjects.runtime.authentication.AuthenticationManager;
import org.nakedobjects.runtime.context.NakedObjectsContextStatic;
import org.nakedobjects.runtime.imageloader.TemplateImageLoader;
import org.nakedobjects.runtime.persistence.PersistenceSession;
import org.nakedobjects.runtime.persistence.PersistenceSessionFactory;
import org.nakedobjects.runtime.session.NakedObjectSessionFactory;
import org.nakedobjects.runtime.session.NakedObjectSessionFactoryDefault;
import org.nakedobjects.runtime.system.DeploymentType;
import org.nakedobjects.runtime.userprofile.UserProfileLoader;

@RunWith(value=JMock.class)
public class TextFieldContentTest {
    private TextContent content;
    private Mockery mockery = new JUnit4Mockery();
    protected TemplateImageLoader mockTemplateImageLoader;
    protected SpecificationLoader mockSpecificationLoader;
    private UserProfileLoader mockUserProfileLoader;
    protected PersistenceSessionFactory mockPersistenceSessionFactory;
    protected PersistenceSession mockPersistenceSession;
    protected AuthenticationManager mockAuthenticationManager;
    private List<Object> servicesList;

    @Before
    public void setUp() throws Exception {
        Logger.getRootLogger().setLevel(Level.OFF);
        this.servicesList = Collections.emptyList();
        this.mockTemplateImageLoader = (TemplateImageLoader)this.mockery.mock(TemplateImageLoader.class);
        this.mockSpecificationLoader = (SpecificationLoader)this.mockery.mock(SpecificationLoader.class);
        this.mockUserProfileLoader = (UserProfileLoader)this.mockery.mock(UserProfileLoader.class);
        this.mockPersistenceSessionFactory = (PersistenceSessionFactory)this.mockery.mock(PersistenceSessionFactory.class);
        this.mockPersistenceSession = (PersistenceSession)this.mockery.mock(PersistenceSession.class);
        this.mockAuthenticationManager = (AuthenticationManager)this.mockery.mock(AuthenticationManager.class);
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                this.ignoring(TextFieldContentTest.this.mockTemplateImageLoader);
                this.ignoring(TextFieldContentTest.this.mockSpecificationLoader);
                this.ignoring(TextFieldContentTest.this.mockUserProfileLoader);
                this.ignoring(TextFieldContentTest.this.mockPersistenceSessionFactory);
                this.ignoring(TextFieldContentTest.this.mockAuthenticationManager);
            }
        });
        NakedObjectSessionFactoryDefault sessionFactory = new NakedObjectSessionFactoryDefault(DeploymentType.EXPLORATION, (NakedObjectConfiguration)new PropertiesConfiguration(), this.mockTemplateImageLoader, this.mockSpecificationLoader, this.mockAuthenticationManager, this.mockUserProfileLoader, this.mockPersistenceSessionFactory, this.servicesList);
        sessionFactory.init();
        NakedObjectsContextStatic.createRelaxedInstance((NakedObjectSessionFactory)sessionFactory);
        TextBlockTargetExample target = new TextBlockTargetExample();
        this.content = new TextContent((TextBlockTarget)target, 4, 0);
    }

    @Test
    public void testCreate() {
        Assert.assertEquals((Object)"", (Object)this.content.getText());
        Assert.assertEquals((long)1L, (long)this.content.getNoLinesOfContent());
    }

    @Test
    public void testDeleteLeft() {
        this.content.setText("abcdefghijklm");
        this.content.deleteLeft(new CursorPosition(this.content, 0, 2));
        Assert.assertEquals((Object)"acdefghijklm", (Object)this.content.getText());
    }

    @Test
    public void testDeleteRight() {
        this.content.setText("abcdefghijklm");
        this.content.deleteRight(new CursorPosition(this.content, 0, 2));
        Assert.assertEquals((Object)"abdefghijklm", (Object)this.content.getText());
    }

    @Test
    public void testDisplayLineCount() {
        Assert.assertEquals((long)4L, (long)this.content.getNoDisplayLines());
    }

    @Test
    public void testMinimalTextEqualsOneLine() {
        this.content.setText("test");
        Assert.assertEquals((long)1L, (long)this.content.getNoLinesOfContent());
    }

    @Test
    public void testInsert() {
    }

    @Test
    public void testNumberOfDisplayLines() {
        Assert.assertEquals((long)4L, (long)this.content.getNoDisplayLines());
        Assert.assertEquals((long)4L, (long)this.content.getDisplayLines().length);
        Assert.assertEquals((Object)"", (Object)this.content.getDisplayLines()[0]);
        Assert.assertEquals((Object)"", (Object)this.content.getDisplayLines()[1]);
        Assert.assertEquals((Object)"", (Object)this.content.getDisplayLines()[2]);
        Assert.assertEquals((Object)"", (Object)this.content.getDisplayLines()[3]);
        this.content.setNoDisplayLines(6);
        Assert.assertEquals((long)6L, (long)this.content.getNoDisplayLines());
        Assert.assertEquals((long)6L, (long)this.content.getDisplayLines().length);
        Assert.assertEquals((Object)"", (Object)this.content.getDisplayLines()[0]);
        Assert.assertEquals((Object)"", (Object)this.content.getDisplayLines()[1]);
        Assert.assertEquals((Object)"", (Object)this.content.getDisplayLines()[2]);
        Assert.assertEquals((Object)"", (Object)this.content.getDisplayLines()[3]);
        Assert.assertEquals((Object)"", (Object)this.content.getDisplayLines()[4]);
        Assert.assertEquals((Object)"", (Object)this.content.getDisplayLines()[5]);
    }

    @Test
    public void testAlignField() {
        this.content.setText("Naked Objects - a framework that exposes behaviourally complete business objects directly to the user. Copyright (C) 2000 - 2005 Naked Objects Group");
        Assert.assertEquals((long)9L, (long)this.content.getNoLinesOfContent());
        String[] lines = this.content.getDisplayLines();
        Assert.assertEquals((long)4L, (long)lines.length);
        Assert.assertEquals((Object)"Naked Objects - a ", (Object)lines[0]);
        Assert.assertEquals((Object)"framework that ", (Object)lines[1]);
        Assert.assertEquals((Object)"exposes ", (Object)lines[2]);
        Assert.assertEquals((Object)"behaviourally complete ", (Object)lines[3]);
        this.content.alignDisplay(6);
        Assert.assertEquals((long)4L, (long)this.content.getNoDisplayLines());
        lines = this.content.getDisplayLines();
        Assert.assertEquals((long)4L, (long)lines.length);
        Assert.assertEquals((Object)"directly to the user. ", (Object)lines[0]);
        Assert.assertEquals((Object)"Copyright (C) 2000 ", (Object)lines[1]);
        Assert.assertEquals((Object)"- 2005 Naked ", (Object)lines[2]);
        Assert.assertEquals((Object)"Objects Group", (Object)lines[3]);
    }

    @Test
    public void testInstert() {
        this.content.setText("at");
        CursorPosition cursor = new CursorPosition(this.content, 0, 0);
        this.content.insert(cursor, "fl");
        Assert.assertEquals((Object)"flat", (Object)this.content.getText());
        Assert.assertEquals((long)4L, (long)this.content.getNoDisplayLines());
        Assert.assertEquals((long)1L, (long)this.content.getNoLinesOfContent());
    }

    @Test
    public void testInstertOverTheEndOfLine() {
        CursorPosition cursor = new CursorPosition(this.content, 0, 0);
        this.content.insert(cursor, "test insert that is longer than the four lines that were originally allocated for this test");
        Assert.assertEquals((Object)"test insert that is longer than the four lines that were originally allocated for this test", (Object)this.content.getText());
        Assert.assertEquals((long)4L, (long)this.content.getNoDisplayLines());
        Assert.assertEquals((long)6L, (long)this.content.getNoLinesOfContent());
    }

    @Test
    public void testCursorPostioningAtCorner() {
        this.content.setText("test insert that is longer than a single line");
        Assert.assertEquals((long)0L, (long)this.content.cursorAtLine(new Location()));
        Assert.assertEquals((long)0L, (long)this.content.cursorAtCharacter(new Location(), 0));
    }

    @Test
    public void testCursorPostioningByLine() {
        this.content.setText("test insert that is longer than a single line");
        Assert.assertEquals((long)0L, (long)this.content.cursorAtLine(new Location(1000, 0)));
        Assert.assertEquals((long)0L, (long)this.content.cursorAtLine(new Location(1000, 10)));
        Assert.assertEquals((long)0L, (long)this.content.cursorAtLine(new Location(1000, 14)));
        Assert.assertEquals((long)1L, (long)this.content.cursorAtLine(new Location(1000, 15)));
        Assert.assertEquals((long)1L, (long)this.content.cursorAtLine(new Location(1000, 25)));
        Assert.assertEquals((long)1L, (long)this.content.cursorAtLine(new Location(1000, 29)));
        Assert.assertEquals((long)2L, (long)this.content.cursorAtLine(new Location(1000, 30)));
        Assert.assertEquals((long)2L, (long)this.content.cursorAtLine(new Location(1000, 44)));
        Assert.assertEquals((long)3L, (long)this.content.cursorAtLine(new Location(1000, 45)));
    }

    @Test
    public void testCursorPostioningByCharacter() {
        this.content.setText("test insert that");
        Assert.assertEquals((long)0L, (long)this.content.cursorAtCharacter(new Location(0, 1000), 0));
        Assert.assertEquals((long)0L, (long)this.content.cursorAtCharacter(new Location(3, 1000), 0));
        Assert.assertEquals((long)1L, (long)this.content.cursorAtCharacter(new Location(4, 1000), 0));
        Assert.assertEquals((long)1L, (long)this.content.cursorAtCharacter(new Location(13, 1000), 0));
        Assert.assertEquals((long)2L, (long)this.content.cursorAtCharacter(new Location(14, 1000), 0));
        Assert.assertEquals((long)2L, (long)this.content.cursorAtCharacter(new Location(23, 1000), 0));
        Assert.assertEquals((long)15L, (long)this.content.cursorAtCharacter(new Location(153, 1000), 0));
        Assert.assertEquals((long)16L, (long)this.content.cursorAtCharacter(new Location(154, 1000), 0));
        Assert.assertEquals((long)16L, (long)this.content.cursorAtCharacter(new Location(199, 1000), 0));
    }

    @Test
    public void testCursorPostioningByCharacterPastEnd() {
        this.content.setText("test insert that");
        Assert.assertEquals((long)16L, (long)this.content.cursorAtCharacter(new Location(190, 0), 0));
        Assert.assertEquals((long)0L, (long)this.content.cursorAtCharacter(new Location(0, 0), 0));
        Assert.assertEquals((long)16L, (long)this.content.cursorAtCharacter(new Location(35, 0), 2));
    }

    @Test
    public void testCursorPostioningByCharacterOnLine2() {
        this.content.setNoDisplayLines(4);
        this.content.setText("test insert that that spans three lines only");
        Assert.assertEquals((long)0L, (long)this.content.cursorAtCharacter(new Location(0, 1000), 2));
        Assert.assertEquals((long)0L, (long)this.content.cursorAtCharacter(new Location(3, 1000), 2));
        Assert.assertEquals((long)1L, (long)this.content.cursorAtCharacter(new Location(4, 1000), 2));
        Assert.assertEquals((long)1L, (long)this.content.cursorAtCharacter(new Location(13, 1000), 2));
        Assert.assertEquals((long)2L, (long)this.content.cursorAtCharacter(new Location(14, 1000), 2));
        Assert.assertEquals((long)2L, (long)this.content.cursorAtCharacter(new Location(23, 1000), 2));
        Assert.assertEquals((long)10L, (long)this.content.cursorAtCharacter(new Location(14, 1000), 3));
        Assert.assertEquals((long)10L, (long)this.content.cursorAtCharacter(new Location(23, 1000), 3));
    }
}

