/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd;

public class ViewState
implements Cloneable {
    private static final short CAN_DROP = 16;
    private static final short CANT_DROP = 8;
    private static final short CONTENT_IDENTIFIED = 4;
    private static final short ROOT_VIEW_IDENTIFIED = 1;
    private static final short VIEW_IDENTIFIED = 2;
    private static final short INVALID = 64;
    private static final short ACTIVE = 32;
    private static final short OUT_OF_SYNCH = 128;
    private short state;

    public void setCanDrop() {
        this.state = (short)(this.state | 0x10);
    }

    public void setCantDrop() {
        this.state = (short)(this.state | 8);
    }

    public void setContentIdentified() {
        this.state = (short)(this.state | 4);
    }

    public boolean isObjectIdentified() {
        return (this.state & 4) > 0;
    }

    public void setRootViewIdentified() {
        this.state = (short)(this.state | 1);
    }

    public boolean isRootViewIdentified() {
        return (this.state & 1) > 0;
    }

    public void setViewIdentified() {
        this.state = (short)(this.state | 2);
    }

    public boolean isViewIdentified() {
        return (this.state & 2) > 0;
    }

    public boolean canDrop() {
        return (this.state & 0x10) == 16;
    }

    public boolean cantDrop() {
        return (this.state & 8) == 8;
    }

    public void clearObjectIdentified() {
        this.state = (short)(this.state & 0xFFFFFFE3);
    }

    public void clearRootViewIdentified() {
        this.state = (short)(this.state & 0xFFFFFFFE);
    }

    public void clearViewIdentified() {
        this.state = (short)(this.state & 0xFFFFFFE1);
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        String str = "";
        if (this.state == 0) {
            str = "Normal";
        } else {
            str = str + (this.isObjectIdentified() ? "Object-Identified " : "");
            str = str + (this.isViewIdentified() ? "View-identified " : "");
            str = str + (this.isRootViewIdentified() ? "Root-view-identified " : "");
            str = str + (this.canDrop() ? "Can-drop " : "");
            str = str + (this.cantDrop() ? "Cant-drop " : "");
            str = str + (this.isActive() ? "Active " : "");
            str = str + (this.isInvalid() ? "Invalid " : "");
            str = str + (this.isOutOfSynch() ? "Out-of-synch " : "");
            str = str + " " + Integer.toBinaryString(this.state);
        }
        return str;
    }

    public void setActive() {
        this.setFlag((short)32);
    }

    public void setInactive() {
        this.resetFlag((short)32);
    }

    public boolean isActive() {
        return this.isFlagSet((short)32);
    }

    private boolean isFlagSet(short flag) {
        return (this.state & flag) > 0;
    }

    public void clearInvalid() {
        this.resetFlag((short)64);
    }

    private void setFlag(short flag) {
        this.state = (short)(this.state | flag);
    }

    public void setInvalid() {
        this.setFlag((short)64);
    }

    private void resetFlag(short flag) {
        this.state = (short)(this.state & ~flag);
    }

    public boolean isInvalid() {
        return this.isFlagSet((short)64);
    }

    public boolean isOutOfSynch() {
        return this.isFlagSet((short)128);
    }

    public void setOutOfSynch() {
        this.setFlag((short)128);
    }

    public void clearOutOfSynch() {
        this.resetFlag((short)128);
    }
}

