/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd.bootstrap;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.commons.factory.InstanceCreationException;
import org.nakedobjects.metamodel.commons.factory.InstanceFactory;
import org.nakedobjects.metamodel.config.ConfigurationException;
import org.nakedobjects.plugins.dnd.HelpViewer;
import org.nakedobjects.plugins.dnd.Toolkit;
import org.nakedobjects.plugins.dnd.View;
import org.nakedobjects.plugins.dnd.ViewRequirement;
import org.nakedobjects.plugins.dnd.ViewSpecification;
import org.nakedobjects.plugins.dnd.viewer.AwtToolkit;
import org.nakedobjects.plugins.dnd.viewer.LoginDialog;
import org.nakedobjects.plugins.dnd.viewer.ShutdownListener;
import org.nakedobjects.plugins.dnd.viewer.SkylarkViewFactory;
import org.nakedobjects.plugins.dnd.viewer.ViewerFrame;
import org.nakedobjects.plugins.dnd.viewer.XViewer;
import org.nakedobjects.plugins.dnd.viewer.basic.DragContentSpecification;
import org.nakedobjects.plugins.dnd.viewer.basic.EmptyField;
import org.nakedobjects.plugins.dnd.viewer.basic.InnerWorkspaceSpecification;
import org.nakedobjects.plugins.dnd.viewer.basic.PasswordFieldSpecification;
import org.nakedobjects.plugins.dnd.viewer.basic.RootIconSpecification;
import org.nakedobjects.plugins.dnd.viewer.basic.RootWorkspaceSpecification;
import org.nakedobjects.plugins.dnd.viewer.basic.SubviewIconSpecification;
import org.nakedobjects.plugins.dnd.viewer.basic.WrappedTextFieldSpecification;
import org.nakedobjects.plugins.dnd.viewer.content.PerspectiveContent;
import org.nakedobjects.plugins.dnd.viewer.drawing.Bounds;
import org.nakedobjects.plugins.dnd.viewer.drawing.Location;
import org.nakedobjects.plugins.dnd.viewer.drawing.Size;
import org.nakedobjects.plugins.dnd.viewer.image.ImageFactory;
import org.nakedobjects.plugins.dnd.viewer.list.ExpandableListSpecification;
import org.nakedobjects.plugins.dnd.viewer.list.GridSpecification;
import org.nakedobjects.plugins.dnd.viewer.list.HistogramSpecification;
import org.nakedobjects.plugins.dnd.viewer.list.InternalListSpecification;
import org.nakedobjects.plugins.dnd.viewer.list.ListWithExpandableElementsSpecification;
import org.nakedobjects.plugins.dnd.viewer.list.SimpleListSpecification;
import org.nakedobjects.plugins.dnd.viewer.list.SummaryListWindowSpecification;
import org.nakedobjects.plugins.dnd.viewer.notifier.ViewUpdateNotifier;
import org.nakedobjects.plugins.dnd.viewer.table.WindowTableSpecification;
import org.nakedobjects.plugins.dnd.viewer.tree.FormWithDetailSpecification;
import org.nakedobjects.plugins.dnd.viewer.tree.ListWithDetailSpecification;
import org.nakedobjects.plugins.dnd.viewer.tree.TreeSpecification;
import org.nakedobjects.plugins.dnd.viewer.tree.TreeWithDetailSpecification;
import org.nakedobjects.plugins.dnd.viewer.util.Properties;
import org.nakedobjects.plugins.dnd.viewer.view.calendar.CalendarSpecification;
import org.nakedobjects.plugins.dnd.viewer.view.extendedform.ExtendedFormSpecification;
import org.nakedobjects.plugins.dnd.viewer.view.extendedform.TwoPartViewSpecification;
import org.nakedobjects.plugins.dnd.viewer.view.field.CheckboxField;
import org.nakedobjects.plugins.dnd.viewer.view.field.ColorField;
import org.nakedobjects.plugins.dnd.viewer.view.field.ImageField;
import org.nakedobjects.plugins.dnd.viewer.view.field.TextFieldSpecification;
import org.nakedobjects.plugins.dnd.viewer.view.form.WindowExpandableFormSpecification;
import org.nakedobjects.plugins.dnd.viewer.view.form.WindowFormSpecification;
import org.nakedobjects.plugins.dnd.viewer.view.help.InternalHelpViewer;
import org.nakedobjects.plugins.dnd.viewer.view.message.DetailedMessageViewSpecification;
import org.nakedobjects.plugins.dnd.viewer.view.message.MessageDialogSpecification;
import org.nakedobjects.plugins.dnd.viewer.view.specification.ServiceIconSpecification;
import org.nakedobjects.runtime.authentication.AuthenticationRequest;
import org.nakedobjects.runtime.authentication.AuthenticationRequestPassword;
import org.nakedobjects.runtime.authentication.standard.exploration.AuthenticationRequestExploration;
import org.nakedobjects.runtime.authentication.standard.fixture.AuthenticationRequestLogonFixture;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.userprofile.UserProfile;
import org.nakedobjects.runtime.viewer.NakedObjectsViewerAbstract;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DndViewer
extends NakedObjectsViewerAbstract {
    private static final Logger LOG = Logger.getLogger(DndViewer.class);
    private static final String SPECIFICATION_BASE = "nakedobjects.viewer.dnd.specification.";
    private ViewUpdateNotifier updateNotifier;
    private ViewerFrame frame;
    private XViewer viewer;
    private ShutdownListener shutdownListener;
    private Bounds bounds;
    private HelpViewer helpViewer;
    private boolean acceptingLogIns = true;
    private boolean loggedInUsingLogonFixture = false;

    public DndViewer() {
        super(NakedObjectsViewerAbstract.SystemBootstrapping.DOES_NOT_BOOTSTRAP);
    }

    public void shutdown() {
        System.exit(0);
    }

    private Bounds calculateBounds(Dimension screenSize) {
        int maxWidth = screenSize.width;
        int maxHeight = screenSize.height;
        if (screenSize.width / screenSize.height >= 2) {
            int f = screenSize.width / screenSize.height;
            maxWidth = screenSize.width / f;
        }
        int width = maxWidth - 80;
        int height = maxHeight - 80;
        int x = 40;
        int y = 40;
        Size defaultWindowSize = new Size(width, height);
        defaultWindowSize.limitWidth(800);
        defaultWindowSize.limitHeight(600);
        Size size = Properties.getSize("nakedobjects.viewer.dnd.initial.size", defaultWindowSize);
        Location location = Properties.getLocation("nakedobjects.viewer.dnd.initial.location", new Location(40, 40));
        return new Bounds(location, size);
    }

    private ViewSpecification loadSpecification(String name, Class<?> cls) {
        String factoryName = NakedObjectsContext.getConfiguration().getString(SPECIFICATION_BASE + name);
        ViewSpecification spec = factoryName != null ? (ViewSpecification)InstanceFactory.createInstance((String)factoryName, ViewSpecification.class) : (ViewSpecification)InstanceFactory.createInstance((String)cls.getName(), ViewSpecification.class);
        return spec;
    }

    private synchronized void logOut() {
        LOG.info((Object)"user log out");
        this.saveDesktop();
        AuthenticationSession session = NakedObjectsContext.getAuthenticationSession();
        DndViewer.getAuthenticationManager().closeSession(session);
        this.viewer.close();
        ((Object)((Object)this)).notify();
    }

    private void saveDesktop() {
        NakedObjectsContext.getUserProfileLoader().saveSession(new ArrayList());
    }

    protected void quit() {
        LOG.info((Object)"user quit");
        this.saveDesktop();
        this.acceptingLogIns = false;
        this.shutdown();
    }

    public synchronized void init() {
        super.init();
        new ImageFactory(NakedObjectsContext.getTemplateImageLoader());
        new AwtToolkit();
        this.setupViewFactory();
        this.setShutdownListener(new ShutdownListener(){

            public void logOut() {
                DndViewer.this.logOut();
            }

            public void quit() {
                DndViewer.this.quit();
            }
        });
        this.updateNotifier = new ViewUpdateNotifier();
        if (this.updateNotifier == null) {
            throw new NullPointerException("No update notifier set for " + (Object)((Object)this));
        }
        if (this.shutdownListener == null) {
            throw new NullPointerException("No shutdown listener set for " + (Object)((Object)this));
        }
        while (this.acceptingLogIns) {
            if (this.login()) {
                this.openViewer();
                try {
                    ((Object)((Object)this)).wait();
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            this.quit();
        }
    }

    private boolean login() {
        AuthenticationSession session = null;
        AuthenticationRequest request = null;
        request = this.getAuthenticationRequestViaArgs();
        if (request == null && this.getDeploymentType().isExploring()) {
            request = new AuthenticationRequestExploration(this.getLogonFixture());
        }
        if (request == null && this.getLogonFixture() != null && !this.loggedInUsingLogonFixture) {
            this.loggedInUsingLogonFixture = true;
            request = new AuthenticationRequestLogonFixture(this.getLogonFixture());
        }
        session = DndViewer.getAuthenticationManager().authenticate(request);
        this.clearAuthenticationRequestViaArgs();
        while (session == null) {
            if (request == null) {
                request = this.promptForAuthenticationDetails();
            }
            if (request == null) {
                return false;
            }
            session = DndViewer.getAuthenticationManager().authenticate(request);
        }
        NakedObjectsContext.openSession((AuthenticationSession)session);
        return true;
    }

    private AuthenticationRequest promptForAuthenticationDetails() {
        LoginDialog dialog = new LoginDialog();
        dialog.setVisible(true);
        dialog.toFront();
        if (dialog.login()) {
            dialog.setVisible(false);
            dialog.dispose();
            return new AuthenticationRequestPassword(dialog.getUser(), dialog.getPassword());
        }
        dialog.setVisible(false);
        dialog.dispose();
        return null;
    }

    private void openViewer() {
        this.frame = new ViewerFrame();
        if (this.bounds == null) {
            this.bounds = this.calculateBounds(this.frame.getToolkit().getScreenSize());
        }
        this.frame.pack();
        this.frame.setBounds(this.bounds.getX(), this.bounds.getY(), this.bounds.getWidth(), this.bounds.getHeight());
        this.viewer = (XViewer)Toolkit.getViewer();
        this.viewer.setRenderingArea(this.frame);
        this.viewer.setUpdateNotifier(this.updateNotifier);
        this.viewer.setListener(this.shutdownListener);
        this.viewer.setExploration(this.isInExplorationMode());
        if (this.helpViewer == null) {
            this.helpViewer = new InternalHelpViewer(this.viewer);
        }
        this.viewer.setHelpViewer(this.helpViewer);
        this.frame.setViewer(this.viewer);
        AuthenticationSession currentSession = NakedObjectsContext.getAuthenticationSession();
        if (currentSession == null) {
            throw new NullPointerException("No session for " + (Object)((Object)this));
        }
        RootWorkspaceSpecification spec = new RootWorkspaceSpecification();
        UserProfile userProfiler = NakedObjectsContext.getUserProfile();
        PerspectiveContent content = new PerspectiveContent(userProfiler.getPerspective());
        if (!spec.canDisplay(content, new ViewRequirement(content, 1))) {
            throw new NakedObjectException();
        }
        View view = spec.createView(content, null);
        this.viewer.setRootView(view);
        this.viewer.init();
        String name = userProfiler.getPerspective().getName();
        this.frame.setTitle(name);
        this.frame.init();
        this.viewer.initSize();
        this.viewer.scheduleRepaint();
        this.frame.setVisible(true);
        this.frame.toFront();
    }

    private boolean isInExplorationMode() {
        return this.getDeploymentType().isExploring();
    }

    public void setBounds(Bounds bounds) {
        this.bounds = bounds;
    }

    public void setHelpViewer(HelpViewer helpViewer) {
        this.helpViewer = helpViewer;
    }

    public void setShutdownListener(ShutdownListener shutdownListener) {
        this.shutdownListener = shutdownListener;
    }

    private void setupViewFactory() throws ConfigurationException, InstanceCreationException {
        SkylarkViewFactory viewFactory = (SkylarkViewFactory)Toolkit.getViewFactory();
        LOG.debug((Object)"setting up default views (provided by the framework)");
        viewFactory.addSpecification(this.loadSpecification("field.image", ImageField.Specification.class));
        viewFactory.addSpecification(this.loadSpecification("field.color", ColorField.Specification.class));
        viewFactory.addSpecification(this.loadSpecification("field.password", PasswordFieldSpecification.class));
        viewFactory.addSpecification(this.loadSpecification("field.wrappedtext", WrappedTextFieldSpecification.class));
        viewFactory.addSpecification(this.loadSpecification("field.checkbox", CheckboxField.Specification.class));
        viewFactory.addSpecification(this.loadSpecification("field.text", TextFieldSpecification.class));
        viewFactory.addSpecification(new RootWorkspaceSpecification());
        viewFactory.addSpecification(new InnerWorkspaceSpecification());
        if (NakedObjectsContext.getConfiguration().getBoolean("nakedobjects.viewer.dnd.specification.defaults", true)) {
            viewFactory.addSpecification(new InternalListSpecification());
            viewFactory.addSpecification(new SimpleListSpecification());
            viewFactory.addSpecification(new SummaryListWindowSpecification());
            viewFactory.addSpecification(new GridSpecification());
            viewFactory.addSpecification(new ListWithExpandableElementsSpecification());
            viewFactory.addSpecification(new CalendarSpecification());
            viewFactory.addSpecification(new ListWithDetailSpecification());
            viewFactory.addSpecification(new HistogramSpecification());
            viewFactory.addSpecification(new TreeWithDetailSpecification());
            viewFactory.addSpecification(new WindowFormSpecification());
            viewFactory.addSpecification(new WindowTableSpecification());
            viewFactory.addSpecification(new WindowExpandableFormSpecification());
            viewFactory.addSpecification(new TwoPartViewSpecification());
            viewFactory.addSpecification(new ExtendedFormSpecification());
            viewFactory.addSpecification(new FormWithDetailSpecification());
            viewFactory.addSpecification(new TreeSpecification());
        }
        viewFactory.addSpecification(new MessageDialogSpecification());
        viewFactory.addSpecification(new DetailedMessageViewSpecification());
        viewFactory.addEmptyFieldSpecification(this.loadSpecification("field.empty", EmptyField.Specification.class));
        viewFactory.addSpecification(this.loadSpecification("icon.object", RootIconSpecification.class));
        viewFactory.addSpecification(this.loadSpecification("icon.subview", SubviewIconSpecification.class));
        viewFactory.addSpecification(this.loadSpecification("icon.collection", ExpandableListSpecification.class));
        viewFactory.addSpecification(this.loadSpecification("icon.service", SubviewIconSpecification.class));
        viewFactory.addSpecification(this.loadSpecification("icon.service", ServiceIconSpecification.class));
        viewFactory.setDragContentSpecification(this.loadSpecification("drag-content", DragContentSpecification.class));
        String viewParams = NakedObjectsContext.getConfiguration().getString("nakedobjects.viewer.dnd.specification.view");
        if (viewParams != null) {
            StringTokenizer st = new StringTokenizer(viewParams, ",");
            while (st.hasMoreTokens()) {
                String specName = st.nextToken().trim();
                if (specName == null || specName.trim().equals("")) continue;
                ViewSpecification spec = (ViewSpecification)InstanceFactory.createInstance((String)specName);
                LOG.info((Object)("adding view specification: " + spec));
                viewFactory.addSpecification(spec);
            }
        }
    }
}

