/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd.viewer;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;
import java.util.StringTokenizer;
import org.nakedobjects.plugins.dnd.Canvas;
import org.nakedobjects.plugins.dnd.Toolkit;
import org.nakedobjects.plugins.dnd.View;
import org.nakedobjects.plugins.dnd.viewer.AwtColor;
import org.nakedobjects.plugins.dnd.viewer.AwtText;
import org.nakedobjects.plugins.dnd.viewer.RenderingArea;
import org.nakedobjects.plugins.dnd.viewer.drawing.Bounds;
import org.nakedobjects.plugins.dnd.viewer.drawing.Color;
import org.nakedobjects.plugins.dnd.viewer.drawing.Image;
import org.nakedobjects.plugins.dnd.viewer.drawing.Location;
import org.nakedobjects.plugins.dnd.viewer.drawing.Shape;
import org.nakedobjects.plugins.dnd.viewer.drawing.Text;
import org.nakedobjects.plugins.dnd.viewer.image.AwtImage;

public class AwtCanvas
implements Canvas {
    private java.awt.Color color;
    private Font font;
    private final Graphics graphics;
    private final RenderingArea renderingArea;

    private AwtCanvas(Graphics graphics, RenderingArea renderingArea) {
        this.graphics = graphics;
        this.renderingArea = renderingArea;
    }

    public AwtCanvas(Graphics bufferGraphic, RenderingArea renderingArea, int x, int y, int width, int height) {
        this.graphics = bufferGraphic;
        this.renderingArea = renderingArea;
        this.graphics.clipRect(x, y, width, height);
    }

    public void clearBackground(View view, Color color) {
        Bounds bounds = view.getBounds();
        this.drawSolidRectangle(0, 0, bounds.getWidth(), bounds.getHeight(), color);
    }

    private Polygon createOval(int x, int y, int width, int height) {
        int points = 40;
        int[] xPoints = new int[40];
        int[] yPoints = new int[40];
        double radians = 0.0;
        for (int i = 0; i < 40; ++i) {
            xPoints[i] = x + (int)((double)width / 2.0) + (int)((double)width / 2.0 * Math.cos(radians));
            yPoints[i] = y + (int)((double)height / 2.0) + (int)((double)height / 2.0 * Math.sin(radians));
            radians += 0.15707963267948966;
        }
        Polygon p = new Polygon(xPoints, yPoints, 40);
        return p;
    }

    public Canvas createSubcanvas() {
        return new AwtCanvas(this.graphics.create(), this.renderingArea);
    }

    public Canvas createSubcanvas(Bounds bounds) {
        return this.createSubcanvas(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
    }

    public Canvas createSubcanvas(int x, int y, int width, int height) {
        Graphics g = this.graphics.create();
        g.translate(x, y);
        return new AwtCanvas(g, this.renderingArea, 0, 0, width, height);
    }

    public void draw3DRectangle(int x, int y, int width, int height, Color color, boolean raised) {
        this.useColor(color);
        this.graphics.draw3DRect(x, y, width - 1, height - 1, raised);
    }

    public void drawDebugOutline(Bounds bounds, int baseline, Color color) {
        int width = bounds.getWidth();
        int height = bounds.getHeight();
        this.drawRectangle(bounds.getX(), bounds.getY(), width, height, color);
        int midpoint = bounds.getY() + height / 2;
        this.drawLine(bounds.getX(), midpoint, width - 2, midpoint, color);
        if (baseline > 0) {
            this.drawLine(bounds.getX(), baseline, width - 1, baseline, Toolkit.getColor("color.debug.baseline"));
        }
    }

    public void drawImage(Image image, int x, int y) {
        this.graphics.drawImage(((AwtImage)image).getAwtImage(), x, y, (ImageObserver)((Object)this.renderingArea));
    }

    public void drawImage(Image image, int x, int y, int width, int height) {
        this.graphics.drawImage(((AwtImage)image).getAwtImage(), x, y, width - 1, height - 1, (ImageObserver)((Object)this.renderingArea));
    }

    public void drawLine(int x, int y, int x2, int y2, Color color) {
        this.useColor(color);
        this.graphics.drawLine(x, y, x2, y2);
    }

    public void drawLine(Location start, int xExtent, int yExtent, Color color) {
        this.drawLine(start.getX(), start.getY(), start.getX() + xExtent, start.getY() + yExtent, color);
    }

    public void drawOval(int x, int y, int width, int height, Color color) {
        this.useColor(color);
        Polygon p = this.createOval(x, y, width - 1, height - 1);
        this.graphics.drawPolygon(p);
    }

    public void drawRectangle(int x, int y, int width, int height, Color color) {
        this.useColor(color);
        this.graphics.drawRect(x, y, width - 1, height - 1);
    }

    public void drawRectangleAround(View view, Color color) {
        Bounds bounds = view.getBounds();
        this.drawRectangle(0, 0, bounds.getWidth(), bounds.getHeight(), color);
    }

    public void drawRoundedRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight, Color color) {
        this.useColor(color);
        this.graphics.drawRoundRect(x, y, width - 1, height - 1, arcWidth, arcHeight);
    }

    public void drawShape(Shape shape, Color color) {
        this.useColor(color);
        this.graphics.drawPolygon(shape.getX(), shape.getY(), shape.count());
    }

    public void drawShape(Shape shape, int x, int y, Color color) {
        Shape copy = new Shape(shape);
        copy.translate(x, y);
        this.drawShape(copy, color);
    }

    public void drawSolidOval(int x, int y, int width, int height, Color color) {
        this.useColor(color);
        Polygon p = this.createOval(x, y, width, height);
        this.graphics.fillPolygon(p);
    }

    public void drawSolidRectangle(int x, int y, int width, int height, Color color) {
        this.useColor(color);
        this.graphics.fillRect(x, y, width, height);
    }

    public void drawSolidShape(Shape shape, Color color) {
        this.useColor(color);
        this.graphics.fillPolygon(shape.getX(), shape.getY(), shape.count());
    }

    public void drawSolidShape(Shape shape, int x, int y, Color color) {
        Shape copy = new Shape(shape);
        copy.translate(x, y);
        this.drawSolidShape(copy, color);
    }

    public void drawText(String text, int x, int y, Color color, Text style) {
        this.useColor(color);
        this.useFont(style);
        this.graphics.drawString(text, x, y);
    }

    public void drawText(String text, int x, int y, int maxWidth, Color color, Text style) {
        this.useColor(color);
        this.useFont(style);
        int top = y;
        StringTokenizer lines = new StringTokenizer(text, "\n\r");
        while (lines.hasMoreTokens()) {
            String line = lines.nextToken();
            StringTokenizer words = new StringTokenizer(line, " ");
            StringBuffer l = new StringBuffer();
            int width = 0;
            while (words.hasMoreTokens()) {
                String nextWord = words.nextToken();
                int wordWidth = style.stringWidth(nextWord);
                if ((width += wordWidth) >= maxWidth) {
                    this.graphics.drawString(l.toString(), x + (line.startsWith("\t") ? 20 : 0), top);
                    top += style.getLineHeight();
                    l.setLength(0);
                    width = wordWidth;
                }
                l.append(nextWord);
                l.append(" ");
                width += style.stringWidth(" ");
            }
            this.graphics.drawString(l.toString(), x + (line.startsWith("\t") ? 20 : 0), top);
            top += style.getLineHeight();
        }
    }

    public void offset(int x, int y) {
        this.graphics.translate(x, y);
    }

    public boolean overlaps(Bounds bounds) {
        Rectangle clip = this.graphics.getClipBounds();
        Bounds activeArea = new Bounds(clip.x, clip.y, clip.width, clip.height);
        return bounds.intersects(activeArea);
    }

    public String toString() {
        Rectangle cb = this.graphics.getClipBounds();
        return "Canvas [area=" + cb.x + "," + cb.y + " " + cb.width + "x" + cb.height + ",color=" + this.color + ",font=" + this.font + "]";
    }

    private void useColor(Color color) {
        java.awt.Color awtColor = ((AwtColor)color).getAwtColor();
        if (this.color != awtColor) {
            this.color = awtColor;
            this.graphics.setColor(awtColor);
        }
    }

    private void useFont(Text style) {
        Font font = ((AwtText)style).getAwtFont();
        if (this.font != font) {
            this.font = font;
            this.graphics.setFont(font);
        }
    }
}

