/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd.viewer;

import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.plugins.dnd.Click;
import org.nakedobjects.plugins.dnd.ContentDrag;
import org.nakedobjects.plugins.dnd.Drag;
import org.nakedobjects.plugins.dnd.DragStart;
import org.nakedobjects.plugins.dnd.InteractionSpy;
import org.nakedobjects.plugins.dnd.NullContent;
import org.nakedobjects.plugins.dnd.View;
import org.nakedobjects.plugins.dnd.ViewAreaType;
import org.nakedobjects.plugins.dnd.viewer.KeyboardManager;
import org.nakedobjects.plugins.dnd.viewer.XFeedbackManager;
import org.nakedobjects.plugins.dnd.viewer.XViewer;
import org.nakedobjects.plugins.dnd.viewer.drawing.Location;
import org.nakedobjects.plugins.dnd.viewer.view.simple.AbstractView;

public class InteractionHandler
implements MouseMotionListener,
MouseListener,
KeyListener {
    private static final Logger LOG = Logger.getLogger(InteractionHandler.class);
    private static final int THRESHOLD = 7;
    private boolean canDrag;
    private Location downAt;
    private Drag drag;
    private final KeyboardManager keyboardManager;
    private View identifiedView;
    private final InteractionSpy spy;
    private final XViewer viewer;
    private KeyEvent lastTyped;
    private View draggedView;
    private final XFeedbackManager feedbackManager;

    public InteractionHandler(XViewer viewer, XFeedbackManager feedbackManager, KeyboardManager keyboardManager, InteractionSpy spy) {
        this.viewer = viewer;
        this.feedbackManager = feedbackManager;
        this.spy = spy;
        this.keyboardManager = keyboardManager;
    }

    private void drag(MouseEvent me) {
        Location location = this.createLocation(me.getPoint());
        this.spy.addAction("Mouse dragged " + location);
        View target = this.viewer.identifyView(new Location(location), false);
        this.drag.drag(target, location, me.getModifiers());
    }

    private Location createLocation(Point point) {
        return new Location(point.x, point.y);
    }

    private void dragStart(MouseEvent me) {
        if (!this.isOverThreshold(this.downAt, me.getPoint())) {
            return;
        }
        this.spy.addAction("Drag start  at " + this.downAt);
        this.drag = this.viewer.dragStart(new DragStart(this.downAt, me.getModifiers()));
        if (this.drag == null) {
            this.spy.addAction("drag start  ignored");
            this.canDrag = false;
        } else {
            this.spy.addAction("drag start " + this.drag);
            View overlay = this.drag.getOverlay();
            if (overlay != null) {
                this.viewer.setOverlayView(overlay);
            }
            View target = this.viewer.identifyView(this.createLocation(me.getPoint()), false);
            this.drag.drag(target, this.createLocation(me.getPoint()), me.getModifiers());
        }
        this.identifiedView = null;
    }

    private boolean isOverThreshold(Location pressed, Point dragged) {
        int xDown = pressed.getX();
        int yDown = pressed.getY();
        int x = dragged.x;
        int y = dragged.y;
        return x > xDown + 7 || x < xDown - 7 || y > yDown + 7 || y < yDown - 7;
    }

    public void keyPressed(KeyEvent ke) {
        if (this.isBusy(this.identifiedView)) {
            return;
        }
        this.lastTyped = null;
        try {
            if (ke.getKeyCode() == 27 && this.drag != null) {
                if (this.drag != null) {
                    this.drag.cancel(this.viewer);
                    this.drag = null;
                }
                this.viewer.clearAction();
            } else if (ke.getKeyCode() == 116) {
                this.draggedView = this.identifiedView;
            } else if (this.draggedView != null && ke.getKeyCode() == 117) {
                ContentDrag content = new ContentDrag(this.draggedView, new Location(), new AbstractView(new NullContent()){});
                if (this.identifiedView != null) {
                    this.identifiedView.drop(content);
                }
                this.draggedView = null;
            } else {
                this.keyboardManager.pressed(ke.getKeyCode(), ke.getModifiers());
            }
            this.redraw();
        }
        catch (Exception e) {
            this.interactionException("keyPressed", e);
        }
    }

    public void keyReleased(KeyEvent ke) {
        if (this.isBusy(this.identifiedView)) {
            return;
        }
        try {
            if (this.lastTyped == null && ke.getKeyCode() != 16 && ke.getKeyCode() != 18 && ke.getKeyCode() != 17 && ke.getKeyCode() >= 48 && ke.getKeyCode() <= 111) {
                LOG.error((Object)("no type event for '" + KeyEvent.getKeyText(ke.getKeyCode()) + "':  " + ke));
            }
            this.keyboardManager.released(ke.getKeyCode(), ke.getModifiers());
            ke.consume();
            this.redraw();
        }
        catch (Exception e) {
            this.interactionException("keyReleased", e);
        }
    }

    public void keyTyped(KeyEvent ke) {
        if (this.isBusy(this.identifiedView)) {
            return;
        }
        char keyChar = ke.getKeyChar();
        if (!Character.isISOControl(keyChar)) {
            this.keyboardManager.typed(keyChar);
            ke.consume();
            this.lastTyped = ke;
            this.redraw();
        }
    }

    private void interactionException(String action, Exception e) {
        LOG.error((Object)("error during user interaction: " + action), (Throwable)e);
        this.feedbackManager.showException(e);
    }

    public void mouseClicked(MouseEvent me) {
        if (this.isBusy(this.identifiedView)) {
            return;
        }
        try {
            Click click = new Click(this.identifiedView, this.downAt, me.getModifiers());
            this.spy.addAction("Mouse clicked " + click.getLocation());
            if (!click.button3() || this.identifiedView == null) {
                if (this.viewer.isOverlayAvailable()) {
                    this.overlayClick(click);
                } else {
                    this.fireClick(click, me.getClickCount());
                }
            }
            this.redraw();
        }
        catch (Exception e) {
            this.interactionException("mouseClicked", e);
        }
    }

    private void overlayClick(Click click) {
        View overlayView = this.viewer.getOverlayView();
        if (overlayView == this.identifiedView || this.identifiedView != null && this.identifiedView.getParent() != null && overlayView == this.identifiedView.getParent()) {
            this.viewer.firstClick(click);
        } else {
            this.viewer.clearAction();
        }
    }

    private void fireMenuPopup(Click click) {
        if (this.identifiedView != null) {
            this.spy.addAction(" popup " + this.downAt + " over " + this.identifiedView);
            boolean forView = this.viewer.viewAreaType(new Location(click.getLocation())) == ViewAreaType.VIEW;
            forView = click.isAlt() ^ forView;
            boolean includeExploration = click.isCtrl();
            boolean includeDebug = click.isShift();
            Location at = click.getLocation();
            at.move(-14, -10);
            this.viewer.popupMenu(this.identifiedView, at, forView, includeExploration, includeDebug);
        }
    }

    private void fireClick(Click click, int clickCount) {
        this.viewer.setKeyboardFocus(this.identifiedView);
        switch (clickCount) {
            case 1: {
                this.viewer.firstClick(click);
                break;
            }
            case 2: {
                this.viewer.secondClick(click);
                break;
            }
            case 3: {
                this.viewer.thirdClick(click);
                break;
            }
        }
    }

    public void mouseDragged(MouseEvent me) {
        if (this.isBusy(this.identifiedView)) {
            return;
        }
        try {
            this.viewer.translate(me);
            Location location = this.createLocation(me.getPoint());
            this.spy.setLocationInViewer(location);
            if (this.canDrag) {
                this.spy.reset();
                if (this.drag == null) {
                    this.dragStart(me);
                    this.redraw();
                } else {
                    this.drag(me);
                    this.redraw();
                }
            }
        }
        catch (Exception e) {
            this.interactionException("mouseDragged", e);
        }
    }

    public void mouseEntered(MouseEvent arg0) {
    }

    public void mouseExited(MouseEvent arg0) {
    }

    public void mouseMoved(MouseEvent me) {
        try {
            if (this.drag == null) {
                this.spy.reset();
                this.viewer.translate(me);
                Location location = this.createLocation(me.getPoint());
                this.spy.setLocationInViewer(location);
                View overView = this.viewer.identifyView(new Location(location), true);
                this.spy.setOver(overView);
                this.spy.addAction("moved " + location);
                if (overView != null) {
                    if (overView != this.identifiedView) {
                        if (this.identifiedView != null) {
                            this.spy.addAction("exited " + this.identifiedView);
                            this.identifiedView.exited();
                        }
                        if (overView != null) {
                            this.spy.addAction("entered " + overView);
                            overView.entered();
                        }
                        this.redraw();
                        this.feedbackManager.showBusyState(overView);
                    }
                    this.identifiedView = overView;
                    this.spy.addTrace("--> mouse moved");
                    this.viewer.mouseMoved(location);
                    this.spy.addTrace(overView, " mouse location", location);
                    if ((me.getModifiers() & 8) > 0 && overView.getContent() != null) {
                        NakedObject object = overView.getContent().getNaked();
                        ViewAreaType area = overView.viewAreaType(location);
                        this.feedbackManager.setViewDetail("Over " + location + " [" + area + "] " + object);
                    }
                    this.redraw();
                }
            }
        }
        catch (Exception e) {
            this.interactionException("mouseMoved", e);
        }
    }

    private boolean isBusy(View view) {
        return this.feedbackManager != null && this.feedbackManager.isBusy(view);
    }

    public void mousePressed(MouseEvent me) {
        try {
            if (this.isBusy(this.identifiedView)) {
                return;
            }
            this.spy.reset();
            this.viewer.translate(me);
            this.downAt = this.createLocation(me.getPoint());
            this.spy.setDownAt(this.downAt);
            Location location = this.createLocation(me.getPoint());
            this.spy.setLocationInViewer(location);
            View overView = this.viewer.identifyView(new Location(location), true);
            this.spy.setOver(overView);
            this.spy.addAction("Mouse pressed " + location);
            this.drag = null;
            Click click = new Click(null, this.downAt, me.getModifiers());
            if (me.isPopupTrigger()) {
                if (overView != null) {
                    this.fireMenuPopup(click);
                }
            } else {
                this.viewer.mouseDown(click);
                this.canDrag = overView != null && me.getClickCount() == 1;
                this.identifiedView = overView;
            }
            this.redraw();
        }
        catch (Exception e) {
            this.interactionException("mousePressed", e);
        }
    }

    public void mouseReleased(MouseEvent me) {
        if (this.isBusy(this.identifiedView) || this.downAt == null) {
            return;
        }
        try {
            if (this.drag != null) {
                this.mouseDragged(me);
                Location location = this.createLocation(me.getPoint());
                View target = this.viewer.identifyView(new Location(location), false);
                this.drag.drag(target, location, me.getModifiers());
                this.drag.end(this.viewer);
                this.redraw();
                this.drag = null;
            }
            Click click = new Click(this.identifiedView, this.downAt, me.getModifiers());
            if (me.isPopupTrigger()) {
                if (this.identifiedView != null) {
                    this.fireMenuPopup(click);
                }
            } else {
                this.viewer.mouseUp(click);
            }
            this.redraw();
        }
        catch (Exception e) {
            this.interactionException("mouseReleased", e);
        }
    }

    private void redraw() {
        this.viewer.scheduleRepaint();
    }
}

