/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd.viewer;

import java.awt.Button;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import org.apache.log4j.Logger;
import org.nakedobjects.plugins.dnd.viewer.AWTUtilities;

public class LoginDialog
extends Frame
implements ActionListener,
KeyListener {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(LoginDialog.class);
    private static final int BORDER = 10;
    private TextField user;
    private TextField password;
    private Button cancel;
    private Button login;
    private static String CANCEL_LABEL = "Cancel";
    private static String LOGIN_LABEL = "Login";
    private boolean logIn = true;

    public LoginDialog() {
        super("Naked Objects Login");
        AWTUtilities.addWindowIcon(this, "login-logo.png");
        this.setLayout(new GridLayout(3, 2, 10, 10));
        this.setResizable(false);
        this.add(new Label("User name:", 0));
        this.user = new TextField();
        this.add(this.user);
        this.user.addKeyListener(this);
        this.add(new Label("Password:", 0));
        this.password = new TextField();
        this.add(this.password);
        this.password.addKeyListener(this);
        this.password.setEchoChar('*');
        this.cancel = new Button(CANCEL_LABEL);
        this.add(this.cancel);
        this.cancel.addActionListener(this);
        this.cancel.addKeyListener(this);
        this.login = new Button(LOGIN_LABEL);
        this.add(this.login);
        this.login.addActionListener(this);
        this.login.addKeyListener(this);
        this.pack();
        int width = this.getSize().width;
        int height = this.getSize().height;
        Dimension screen = this.getToolkit().getScreenSize();
        int x = screen.width / 2 - width / 2;
        if (screen.width / screen.height >= 2) {
            x = screen.width / 4 - width / 2;
        }
        int y = screen.height / 2 - height / 2;
        this.setLocation(x, y);
        this.user.requestFocus();
    }

    public Insets getInsets() {
        Insets in = super.getInsets();
        in.top += 10;
        in.bottom += 10;
        in.left += 10;
        in.right += 10;
        return in;
    }

    public void actionPerformed(ActionEvent evt) {
        this.action(evt.getSource());
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.action(e.getComponent());
        }
        if (e.getKeyCode() == 27) {
            this.cancel(e.getComponent());
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    private synchronized void cancel(Object widget) {
        this.logIn = false;
        this.notify();
    }

    private synchronized void action(Object widget) {
        if (widget == this.cancel) {
            this.cancel(widget);
        } else if (widget == this.login || widget == this.password) {
            this.logIn = true;
            this.notify();
        } else if (widget == this.user) {
            this.password.requestFocus();
        }
    }

    public void dispose() {
        LOG.debug((Object)"dispose...");
        super.dispose();
        LOG.debug((Object)"...disposed");
    }

    public String getUser() {
        return this.removeTabs(this.user.getText()).trim();
    }

    public String getPassword() {
        return this.removeTabs(this.password.getText()).trim();
    }

    private String removeTabs(String text) {
        if (text.indexOf(9) == -1) {
            return text;
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '\t') continue;
            buf.append(text.charAt(i));
        }
        return buf.toString();
    }

    public synchronized boolean login() {
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.logIn;
    }
}

