/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd.viewer.basic;

import java.util.Enumeration;
import java.util.Vector;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.plugins.dnd.Canvas;
import org.nakedobjects.plugins.dnd.Click;
import org.nakedobjects.plugins.dnd.Content;
import org.nakedobjects.plugins.dnd.KeyboardAction;
import org.nakedobjects.plugins.dnd.MenuOptions;
import org.nakedobjects.plugins.dnd.NullContent;
import org.nakedobjects.plugins.dnd.Toolkit;
import org.nakedobjects.plugins.dnd.UserAction;
import org.nakedobjects.plugins.dnd.UserActionSet;
import org.nakedobjects.plugins.dnd.View;
import org.nakedobjects.plugins.dnd.viewer.basic.PopupMenu;
import org.nakedobjects.plugins.dnd.viewer.debug.DebugOption;
import org.nakedobjects.plugins.dnd.viewer.drawing.Color;
import org.nakedobjects.plugins.dnd.viewer.drawing.Location;
import org.nakedobjects.plugins.dnd.viewer.drawing.Size;
import org.nakedobjects.plugins.dnd.viewer.view.simple.AbstractView;

public class PopupMenuContainer
extends AbstractView {
    private static final int MENU_OVERLAP = 4;
    private static final UserAction DEBUG_OPTION = new DebugOption();
    private PopupMenu menu;
    private PopupMenu submenu;
    private Color backgroundColor;
    private View target;
    private final Vector options = new Vector();
    private final Location at;
    private boolean isLayoutInvalid;

    public PopupMenuContainer(View target, Location at) {
        super(new NullContent(), null, null);
        this.target = target;
        this.at = at;
        this.setLocation(at);
        this.isLayoutInvalid = true;
    }

    public void debug(DebugString debug) {
        super.debug(debug);
        debug.appendTitle("Submenu");
        debug.append((Object)this.submenu);
        debug.append((Object)"\n");
    }

    public void dispose() {
        if (this.getParent() == null) {
            super.dispose();
            this.getViewManager().clearOverlayView(this);
        } else {
            this.getParent().dispose();
        }
    }

    public Size getMaximumSize() {
        Size size = this.menu.getMaximumSize();
        if (this.submenu != null) {
            Size subviewSize = this.submenu.getMaximumSize();
            size.extendWidth(subviewSize.getWidth() - 4);
            size.ensureHeight(this.submenuOffset() + subviewSize.getHeight());
        }
        return size;
    }

    public void layout(Size maximumSize) {
        if (this.isLayoutInvalid) {
            this.menu.layout(maximumSize);
            Size menuSize = this.menu.getMaximumSize();
            this.menu.setSize(menuSize);
            this.menu.setLocation(new Location(0, 0));
            Location containerLocation = new Location(this.at);
            Size bounds = this.getViewManager().getOverlaySize();
            if (containerLocation.getX() < 0) {
                containerLocation.setX(0);
            } else if (containerLocation.getX() + menuSize.getWidth() > bounds.getWidth()) {
                containerLocation.setX(bounds.getWidth() - menuSize.getWidth());
            }
            if (containerLocation.getY() < 0) {
                containerLocation.setY(0);
            } else if (containerLocation.getY() + menuSize.getHeight() > bounds.getHeight()) {
                containerLocation.setY(bounds.getHeight() - menuSize.getHeight());
            }
            if (this.submenu != null) {
                boolean placeToLeft;
                this.submenu.layout(maximumSize);
                Size submenuSize = this.submenu.getMaximumSize();
                this.submenu.setSize(submenuSize);
                int submenuOffset = this.submenuOffset();
                Location menuLocation = new Location();
                int containerBottom = containerLocation.getY() + submenuOffset + submenuSize.getHeight();
                if (containerBottom > bounds.getHeight()) {
                    int overstretch = containerBottom - bounds.getHeight();
                    submenuOffset -= overstretch;
                }
                Location submenuLocation = new Location(0, submenuOffset);
                boolean bl = placeToLeft = this.at.getX() + menuSize.getWidth() + submenuSize.getWidth() < this.getViewManager().getOverlaySize().getWidth();
                if (placeToLeft) {
                    submenuLocation.setX(menuSize.getWidth() - 4);
                } else {
                    menuLocation.setX(submenuSize.getWidth() - 4);
                    containerLocation.move(-this.submenu.getSize().getWidth() + 4, 0);
                }
                if (containerLocation.getY() + menuSize.getHeight() > bounds.getHeight()) {
                    containerLocation.setY(bounds.getHeight() - menuSize.getHeight());
                }
                this.submenu.setLocation(submenuLocation);
                this.menu.setLocation(menuLocation);
            }
            this.setLocation(containerLocation);
        }
    }

    private int submenuOffset() {
        return this.menu.getOptionPostion();
    }

    public void mouseMoved(Location at) {
        if (this.menu.getBounds().contains(at)) {
            at.subtract(this.menu.getLocation());
            this.menu.mouseMoved(at);
        } else if (this.submenu != null && this.submenu.getBounds().contains(at)) {
            at.subtract(this.submenu.getLocation());
            this.submenu.mouseMoved(at);
        }
    }

    public void show(boolean forView, boolean includeDebug, boolean includeExploration) {
        boolean withExploration = this.getViewManager().isRunningAsExploration() && includeExploration;
        UserActionSet optionSet = new UserActionSet(withExploration, includeDebug, UserAction.USER);
        if (forView) {
            this.target.viewMenuOptions(optionSet);
        } else {
            this.target.contentMenuOptions(optionSet);
        }
        optionSet.add(DEBUG_OPTION);
        Enumeration e = this.options.elements();
        while (e.hasMoreElements()) {
            MenuOptions element = (MenuOptions)e.nextElement();
            element.menuOptions(optionSet);
        }
        this.menu = new PopupMenu(this);
        this.backgroundColor = optionSet.getColor();
        this.menu.show(this.target, optionSet.getMenuOptions(), this.backgroundColor);
        this.getViewManager().setOverlayView(this);
        String status = this.changeStatus(this.target, forView, withExploration, includeDebug);
        this.getFeedbackManager().setViewDetail(status);
    }

    private String changeStatus(View over, boolean forView, boolean includeExploration, boolean includeDebug) {
        StringBuffer status = new StringBuffer("Menu for ");
        if (forView) {
            status.append("view ");
            status.append(over.getSpecification().getName());
        } else {
            status.append("object");
            Content content = over.getContent();
            if (content != null) {
                status.append(" '");
                status.append(content.title());
                status.append("'");
            }
        }
        if (includeDebug || includeExploration) {
            status.append(" (includes ");
            if (includeExploration) {
                status.append("exploration");
            }
            if (includeDebug) {
                if (includeExploration) {
                    status.append(" & ");
                }
                status.append("debug");
            }
            status.append(" options)");
        }
        return status.toString();
    }

    public void addMenuOptions(MenuOptions options) {
        this.options.addElement(options);
    }

    void openSubmenu(UserAction[] options) {
        this.markDamaged();
        this.submenu = new PopupMenu(this);
        this.submenu.setParent(this);
        this.submenu.show(this.target, options, this.backgroundColor);
        this.invalidateLayout();
        Size size = this.getMaximumSize();
        this.setSize(size);
        this.layout(size);
        this.isLayoutInvalid = false;
        this.markDamaged();
    }

    public void keyPressed(KeyboardAction key) {
        if (this.submenu != null) {
            int keyCode = key.getKeyCode();
            if (keyCode == 27) {
                this.markDamaged();
                this.invalidateLayout();
                this.submenu = null;
                key.consume();
            } else if (this.getParent() != null && keyCode == 37) {
                this.markDamaged();
                this.invalidateLayout();
                this.submenu = null;
                key.consume();
            } else {
                this.submenu.keyPressed(key);
            }
        } else {
            this.menu.keyPressed(key);
        }
    }

    public void invalidateLayout() {
        this.isLayoutInvalid = true;
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (this.menu != null) {
            Canvas menuCanvas = canvas.createSubcanvas(this.menu.getBounds());
            this.menu.draw(menuCanvas);
        }
        if (this.submenu != null) {
            Canvas submenuCanvas = canvas.createSubcanvas(this.submenu.getBounds());
            this.submenu.draw(submenuCanvas);
        }
        if (Toolkit.debug) {
            canvas.drawRectangleAround(this, Toolkit.getColor("color.debug.bounds.view"));
        }
    }

    public void firstClick(Click click) {
        Location location = click.getLocation();
        if (this.menu.getBounds().contains(location)) {
            click.subtract(this.menu.getLocation());
            this.menu.firstClick(click);
        } else if (this.submenu != null && this.submenu.getBounds().contains(location)) {
            click.subtract(this.submenu.getLocation());
            this.submenu.firstClick(click);
        }
    }
}

