/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd.viewer.basic;

import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.plugins.dnd.Canvas;
import org.nakedobjects.plugins.dnd.ContentDrag;
import org.nakedobjects.plugins.dnd.Toolkit;
import org.nakedobjects.plugins.dnd.View;
import org.nakedobjects.plugins.dnd.viewer.border.AbstractViewDecorator;
import org.nakedobjects.plugins.dnd.viewer.drawing.Color;
import org.nakedobjects.plugins.dnd.viewer.drawing.Size;

public class SimpleIdentifier
extends AbstractViewDecorator {
    public SimpleIdentifier(View wrappedView) {
        super(wrappedView);
    }

    public void debugDetails(DebugString debug) {
        debug.append((Object)"SimpleIdentifier");
    }

    public void dragIn(ContentDrag drag) {
        this.wrappedView.dragIn(drag);
        this.markDamaged();
    }

    public void dragOut(ContentDrag drag) {
        this.wrappedView.dragOut(drag);
        this.markDamaged();
    }

    public void draw(Canvas canvas) {
        Color color = null;
        if (this.getState().canDrop()) {
            color = Toolkit.getColor("color.valid");
        } else if (this.getState().cantDrop()) {
            color = Toolkit.getColor("color.invalid");
        } else if (this.getState().isViewIdentified() || this.getState().isObjectIdentified()) {
            color = Toolkit.getColor("color.primary1");
        }
        this.wrappedView.draw(canvas.createSubcanvas());
        if (color != null) {
            Size s = this.getSize();
            canvas.drawRectangle(0, 0, s.getWidth() - 1, s.getHeight() - 1, color);
            canvas.drawRectangle(1, 1, s.getWidth() - 3, s.getHeight() - 3, color);
        }
    }

    public void entered() {
        this.getState().setContentIdentified();
        this.wrappedView.entered();
        this.markDamaged();
    }

    public void exited() {
        this.getState().clearObjectIdentified();
        this.wrappedView.exited();
        this.markDamaged();
    }

    public String toString() {
        return this.wrappedView.toString() + "/SimpleIdentifier";
    }
}

