/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd.viewer.border;

import org.nakedobjects.plugins.dnd.Canvas;
import org.nakedobjects.plugins.dnd.Click;
import org.nakedobjects.plugins.dnd.Content;
import org.nakedobjects.plugins.dnd.UserActionSet;
import org.nakedobjects.plugins.dnd.View;
import org.nakedobjects.plugins.dnd.viewer.action.CloseWindowControl;
import org.nakedobjects.plugins.dnd.viewer.action.IconizeViewOption;
import org.nakedobjects.plugins.dnd.viewer.action.IconizeWindowControl;
import org.nakedobjects.plugins.dnd.viewer.action.ResizeWindowControl;
import org.nakedobjects.plugins.dnd.viewer.action.WindowControl;
import org.nakedobjects.plugins.dnd.viewer.border.AbstractWindowBorder;
import org.nakedobjects.plugins.dnd.viewer.border.ButtonBorder;
import org.nakedobjects.plugins.dnd.viewer.border.SaveTransientObjectBorder;
import org.nakedobjects.plugins.dnd.viewer.border.ScrollBorder;

public class WindowBorder
extends AbstractWindowBorder {
    private static final IconizeViewOption iconizeOption = new IconizeViewOption();

    public WindowBorder(View wrappedView, boolean scrollable) {
        super(WindowBorder.addTransientBorderIfNeccessary(scrollable ? new ScrollBorder(wrappedView) : wrappedView));
        if (this.isTransient()) {
            this.setControls(new WindowControl[]{new CloseWindowControl(this)});
        } else {
            this.setControls(new WindowControl[]{new IconizeWindowControl(this), new ResizeWindowControl(this), new CloseWindowControl(this)});
        }
    }

    private static View addTransientBorderIfNeccessary(View view) {
        Content content = view.getContent();
        if (content.isPersistable() && content.isTransient()) {
            return new SaveTransientObjectBorder(view);
        }
        return view;
    }

    public View[] getButtons() {
        if (this.wrappedView instanceof ButtonBorder) {
            return ((ButtonBorder)this.wrappedView).getButtons();
        }
        return new View[0];
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (this.isTransient()) {
            this.borderRender.drawTransientMarker(canvas, this.getSize());
        }
    }

    private boolean isTransient() {
        Content content = this.getContent();
        return content.isPersistable() && content.isTransient();
    }

    public void viewMenuOptions(UserActionSet menuOptions) {
        super.viewMenuOptions(menuOptions);
        menuOptions.add(iconizeOption);
    }

    public void secondClick(Click click) {
        if (this.overBorder(click.getLocation())) {
            iconizeOption.execute(this.getWorkspace(), this.getView(), this.getAbsoluteLocation());
        } else {
            super.secondClick(click);
        }
    }

    protected String title() {
        return this.getContent().windowTitle();
    }
}

