/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd.viewer.content;

import java.util.Enumeration;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.ResolveState;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.commons.exceptions.UnexpectedCallException;
import org.nakedobjects.metamodel.consent.Consent;
import org.nakedobjects.metamodel.consent.ConsentAbstract;
import org.nakedobjects.metamodel.facets.actcoll.typeof.TypeOfFacet;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionFacet;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.metamodel.util.CollectionFacetUtils;
import org.nakedobjects.plugins.dnd.CollectionContent;
import org.nakedobjects.plugins.dnd.CollectionSorter;
import org.nakedobjects.plugins.dnd.Comparator;
import org.nakedobjects.plugins.dnd.UserAction;
import org.nakedobjects.plugins.dnd.UserActionSet;
import org.nakedobjects.plugins.dnd.View;
import org.nakedobjects.plugins.dnd.Workspace;
import org.nakedobjects.plugins.dnd.viewer.action.AbstractUserAction;
import org.nakedobjects.plugins.dnd.viewer.content.AbstractContent;
import org.nakedobjects.plugins.dnd.viewer.content.FieldComparator;
import org.nakedobjects.plugins.dnd.viewer.content.OptionFactory;
import org.nakedobjects.plugins.dnd.viewer.content.SimpleCollectionSorter;
import org.nakedobjects.plugins.dnd.viewer.content.TitleComparator;
import org.nakedobjects.plugins.dnd.viewer.content.TypeComparator;
import org.nakedobjects.plugins.dnd.viewer.drawing.Image;
import org.nakedobjects.plugins.dnd.viewer.drawing.Location;
import org.nakedobjects.plugins.dnd.viewer.image.ImageFactory;

public abstract class AbstractCollectionContent
extends AbstractContent
implements CollectionContent {
    private static final TypeComparator TYPE_COMPARATOR = new TypeComparator();
    private static final TitleComparator TITLE_COMPARATOR = new TitleComparator();
    private static final CollectionSorter sorter = new SimpleCollectionSorter();
    private Comparator order;
    private boolean reverse;

    public final Enumeration allElements() {
        final NakedObject[] elements = this.elements();
        sorter.sort(elements, this.order, this.reverse);
        return new Enumeration(){
            int i = 0;
            int size = elements.length;

            public boolean hasMoreElements() {
                return this.i < this.size;
            }

            public Object nextElement() {
                return elements[this.i++];
            }
        };
    }

    public void debugDetails(DebugString debug) {
        debug.appendln("order", (Object)this.order);
        debug.appendln("reverse order", this.reverse);
    }

    public NakedObject[] elements() {
        NakedObject collection = this.getCollection();
        CollectionFacet facet = CollectionFacetUtils.getCollectionFacetFromSpec((NakedObject)collection);
        NakedObject[] elementsArray = new NakedObject[facet.size(collection)];
        int i = 0;
        Enumeration elements = facet.elements(collection);
        while (elements.hasMoreElements()) {
            elementsArray[i++] = (NakedObject)elements.nextElement();
        }
        return elementsArray;
    }

    public abstract NakedObject getCollection();

    public NakedObjectSpecification getElementSpecification() {
        NakedObject collection = this.getCollection();
        TypeOfFacet facet = collection.getTypeOfFacet();
        return facet.valueSpec();
    }

    public String getDescription() {
        return "Collection";
    }

    public void contentMenuOptions(UserActionSet options) {
        final NakedObject collection = this.getCollection();
        OptionFactory.addObjectMenuOptions(collection, options);
        options.add(new AbstractUserAction("Clear resolved", UserAction.DEBUG){

            public Consent disabled(View component) {
                return ConsentAbstract.allow((collection == null || collection.getResolveState() != ResolveState.TRANSIENT || collection.getResolveState() == ResolveState.GHOST ? 1 : 0) != 0);
            }

            public void execute(Workspace workspace, View view, Location at) {
                collection.changeState(ResolveState.GHOST);
            }
        });
    }

    public void viewMenuOptions(UserActionSet options) {
        UserActionSet sortOptions = new UserActionSet("Sort", options);
        options.add(sortOptions);
        sortOptions.add(new AbstractUserAction("Clear"){

            public Consent disabled(View component) {
                return ConsentAbstract.allow((AbstractCollectionContent.this.order != null ? 1 : 0) != 0);
            }

            public void execute(Workspace workspace, View view, Location at) {
                AbstractCollectionContent.this.order = null;
                view.invalidateContent();
            }
        });
        if (this.reverse) {
            sortOptions.add(new AbstractUserAction("Normal sort order"){

                public Consent disabled(View component) {
                    return ConsentAbstract.allow((AbstractCollectionContent.this.order != null ? 1 : 0) != 0);
                }

                public void execute(Workspace workspace, View view, Location at) {
                    AbstractCollectionContent.this.reverse = false;
                    view.invalidateContent();
                }
            });
        } else {
            sortOptions.add(new AbstractUserAction("Reverse sort order"){

                public Consent disabled(View component) {
                    return ConsentAbstract.allow((AbstractCollectionContent.this.order != null ? 1 : 0) != 0);
                }

                public void execute(Workspace workspace, View view, Location at) {
                    AbstractCollectionContent.this.reverse = true;
                    view.invalidateContent();
                }
            });
        }
        sortOptions.add(new AbstractUserAction("Sort by title"){

            public Consent disabled(View component) {
                return ConsentAbstract.allow((AbstractCollectionContent.this.order != TITLE_COMPARATOR ? 1 : 0) != 0);
            }

            public void execute(Workspace workspace, View view, Location at) {
                AbstractCollectionContent.this.order = TITLE_COMPARATOR;
                view.invalidateContent();
            }
        });
        sortOptions.add(new AbstractUserAction("Sort by type"){

            public Consent disabled(View component) {
                return ConsentAbstract.allow((AbstractCollectionContent.this.order != TYPE_COMPARATOR ? 1 : 0) != 0);
            }

            public void execute(Workspace workspace, View view, Location at) {
                AbstractCollectionContent.this.order = TYPE_COMPARATOR;
                view.invalidateContent();
            }
        });
        NakedObjectAssociation[] fields = this.getElementSpecification().getAssociations();
        for (int i = 0; i < fields.length; ++i) {
            final NakedObjectAssociation field = fields[i];
            sortOptions.add(new AbstractUserAction("Sort by " + field.getName()){

                public void execute(Workspace workspace, View view, Location at) {
                    AbstractCollectionContent.this.order = new FieldComparator(field);
                    view.invalidateContent();
                }
            });
        }
    }

    public void parseTextEntry(String entryText) {
        throw new UnexpectedCallException();
    }

    public void setOrder(Comparator order) {
        this.order = order;
    }

    public void setOrderByField(NakedObjectAssociation field) {
        if (this.order instanceof FieldComparator && ((FieldComparator)this.order).getField() == field) {
            this.reverse = !this.reverse;
        } else {
            this.order = new FieldComparator(field);
            this.reverse = false;
        }
    }

    public void setOrderByElement() {
        if (this.order == TITLE_COMPARATOR) {
            this.reverse = !this.reverse;
        } else {
            this.order = TITLE_COMPARATOR;
            this.reverse = false;
        }
    }

    public NakedObjectAssociation getFieldSortOrder() {
        if (this.order instanceof FieldComparator) {
            return ((FieldComparator)this.order).getField();
        }
        return null;
    }

    public Image getIconPicture(int iconHeight) {
        NakedObject nakedObject = this.getCollection();
        if (nakedObject == null) {
            return ImageFactory.getInstance().loadIcon("emptyField", iconHeight, null);
        }
        NakedObjectSpecification specification = nakedObject.getSpecification();
        Image icon = ImageFactory.getInstance().loadIcon(specification, iconHeight, null);
        if (icon == null) {
            icon = ImageFactory.getInstance().loadDefaultIcon(iconHeight, null);
        }
        return icon;
    }

    public boolean getOrderByElement() {
        return this.order == TITLE_COMPARATOR;
    }

    public boolean getReverseSortOrder() {
        return this.reverse;
    }

    public boolean isOptionEnabled() {
        return false;
    }

    public NakedObject[] getOptions() {
        return null;
    }
}

