/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd.viewer.content;

import org.nakedobjects.applib.query.Query;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.ResolveState;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.ensure.Assert;
import org.nakedobjects.metamodel.commons.exceptions.UnexpectedCallException;
import org.nakedobjects.metamodel.consent.Consent;
import org.nakedobjects.metamodel.consent.ConsentAbstract;
import org.nakedobjects.metamodel.consent.Veto;
import org.nakedobjects.metamodel.services.container.query.QueryCardinality;
import org.nakedobjects.metamodel.services.container.query.QueryFindAllInstances;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.Persistability;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAction;
import org.nakedobjects.metamodel.spec.feature.NakedObjectActionConstants;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociationFilters;
import org.nakedobjects.metamodel.spec.feature.OneToOneAssociation;
import org.nakedobjects.plugins.dnd.Content;
import org.nakedobjects.plugins.dnd.ObjectContent;
import org.nakedobjects.plugins.dnd.Toolkit;
import org.nakedobjects.plugins.dnd.UserAction;
import org.nakedobjects.plugins.dnd.UserActionSet;
import org.nakedobjects.plugins.dnd.View;
import org.nakedobjects.plugins.dnd.Workspace;
import org.nakedobjects.plugins.dnd.viewer.action.AbstractUserAction;
import org.nakedobjects.plugins.dnd.viewer.content.AbstractContent;
import org.nakedobjects.plugins.dnd.viewer.content.OptionFactory;
import org.nakedobjects.plugins.dnd.viewer.drawing.Image;
import org.nakedobjects.plugins.dnd.viewer.drawing.Location;
import org.nakedobjects.plugins.dnd.viewer.image.ImageFactory;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.PersistenceSession;

public abstract class AbstractObjectContent
extends AbstractContent
implements ObjectContent {
    public abstract Consent canClear();

    public Consent canDrop(Content sourceContent) {
        NakedObject target = this.getObject();
        if (!(sourceContent instanceof ObjectContent) || target == null) {
            return new Veto(String.format("Can't drop %s onto empty target", sourceContent.getNaked().titleString()));
        }
        NakedObject source = ((ObjectContent)sourceContent).getObject();
        return this.canDropOntoObject(target, source);
    }

    private Consent canDropOntoObject(NakedObject target, NakedObject source) {
        NakedObjectAction action = this.dropAction(source, target);
        if (action != null) {
            Consent parameterSetValid = action.isProposedArgumentSetValid(target, new NakedObject[]{source});
            parameterSetValid.setDescription("Execute '" + action.getName() + "' with " + source.titleString());
            return parameterSetValid;
        }
        return this.setFieldOfMatchingType(target, source);
    }

    private Consent setFieldOfMatchingType(NakedObject targetAdapter, NakedObject sourceAdapter) {
        NakedObjectAssociation[] fields;
        if (targetAdapter.isTransient() && sourceAdapter.isPersistent()) {
            return new Veto("Can't set field in persistent object with reference to non-persistent object");
        }
        for (NakedObjectAssociation fld : fields = targetAdapter.getSpecification().getAssociations(NakedObjectAssociationFilters.dynamicallyVisible((AuthenticationSession)NakedObjectsContext.getAuthenticationSession(), (NakedObject)targetAdapter))) {
            Consent associationValid;
            if (!fld.isOneToOneAssociation() || !sourceAdapter.getSpecification().isOfType(fld.getSpecification()) || fld.get(targetAdapter) != null || !(associationValid = ((OneToOneAssociation)fld).isAssociationValid(targetAdapter, sourceAdapter)).isAllowed()) continue;
            return associationValid.setDescription("Set field " + fld.getName());
        }
        return new Veto(String.format("No empty field accepting object of type %s in %s", sourceAdapter.getSpecification().getSingularName(), this.title()));
    }

    public abstract Consent canSet(NakedObject var1);

    public abstract void clear();

    public NakedObject drop(Content sourceContent) {
        if (!(sourceContent instanceof ObjectContent)) {
            return null;
        }
        NakedObject source = sourceContent.getNaked();
        Assert.assertNotNull((Object)source);
        NakedObject target = this.getObject();
        Assert.assertNotNull((Object)target);
        if (!this.canDrop(sourceContent).isAllowed()) {
            return null;
        }
        NakedObjectAction action = this.dropAction(source, target);
        if (action != null && action.isProposedArgumentSetValid(target, new NakedObject[]{source}).isAllowed()) {
            return action.execute(target, new NakedObject[]{source});
        }
        NakedObjectAssociation[] associations = target.getSpecification().getAssociations(NakedObjectAssociationFilters.dynamicallyVisible((AuthenticationSession)NakedObjectsContext.getAuthenticationSession(), (NakedObject)target));
        for (int i = 0; i < associations.length; ++i) {
            NakedObjectAssociation association = associations[i];
            if (!association.isOneToOneAssociation() || !source.getSpecification().isOfType(association.getSpecification())) continue;
            OneToOneAssociation otoa = (OneToOneAssociation)association;
            if (association.get(target) != null || !otoa.isAssociationValid(target, source).isAllowed()) continue;
            otoa.setAssociation(target, source);
            break;
        }
        return null;
    }

    private NakedObjectAction dropAction(NakedObject source, NakedObject target) {
        NakedObjectAction action = target.getSpecification().getObjectAction(NakedObjectActionConstants.USER, null, new NakedObjectSpecification[]{source.getSpecification()});
        return action;
    }

    public abstract NakedObject getObject();

    public boolean isPersistable() {
        return this.getObject().getSpecification().persistability() == Persistability.USER_PERSISTABLE;
    }

    public void contentMenuOptions(UserActionSet options) {
        NakedObject object = this.getObject();
        OptionFactory.addObjectMenuOptions(object, options);
        if (this.getObject() == null) {
            OptionFactory.addCreateOptions(this.getSpecification(), options);
        } else {
            options.add(new ExplorationInstances());
        }
        options.add(new ExplorationClone());
        options.add(new DebugClearResolvedOption());
    }

    public void parseTextEntry(String entryText) {
        throw new UnexpectedCallException();
    }

    public abstract void setObject(NakedObject var1);

    public String getIconName() {
        NakedObject object = this.getObject();
        return object == null ? null : object.getIconName();
    }

    public Image getIconPicture(int iconHeight) {
        NakedObject nakedObject = this.getObject();
        if (nakedObject == null) {
            return ImageFactory.getInstance().loadIcon("empty-field", iconHeight, null);
        }
        NakedObjectSpecification specification = nakedObject.getSpecification();
        Image icon = ImageFactory.getInstance().loadIcon(specification, iconHeight, null);
        return icon;
    }

    private static PersistenceSession getPersistenceSession() {
        return NakedObjectsContext.getPersistenceSession();
    }

    public static final class DebugClearResolvedOption
    extends AbstractUserAction {
        private DebugClearResolvedOption() {
            super("Clear resolved", UserAction.DEBUG);
        }

        public Consent disabled(View view) {
            NakedObject object = view.getContent().getNaked();
            return ConsentAbstract.allow((object == null || object.getResolveState() != ResolveState.TRANSIENT || object.getResolveState() == ResolveState.GHOST ? 1 : 0) != 0);
        }

        public void execute(Workspace workspace, View view, Location at) {
            NakedObject object = view.getContent().getNaked();
            object.changeState(ResolveState.GHOST);
        }
    }

    public static final class ExplorationClone
    extends AbstractUserAction {
        public ExplorationClone() {
            super("Clone", UserAction.EXPLORATION);
        }

        public Consent disabled(View view) {
            NakedObject object = view.getContent().getNaked();
            return ConsentAbstract.allow((object != null ? 1 : 0) != 0);
        }

        public void execute(Workspace workspace, View view, Location at) {
            NakedObject original = view.getContent().getNaked();
            NakedObjectSpecification spec = original.getSpecification();
            NakedObject clone = AbstractObjectContent.getPersistenceSession().createInstance(spec);
            NakedObjectAssociation[] fields = spec.getAssociations();
            for (int i = 0; i < fields.length; ++i) {
                NakedObject fld = fields[i].get(original);
                if (fields[i].isOneToOneAssociation()) {
                    ((OneToOneAssociation)fields[i]).setAssociation(clone, fld);
                    continue;
                }
                if (!fields[i].isOneToManyAssociation()) continue;
            }
            Content content = Toolkit.getContentFactory().createRootContent(clone);
            View cloneView = Toolkit.getViewFactory().createWindow(content);
            cloneView.setLocation(at);
            workspace.addView(cloneView);
        }
    }

    public static final class ExplorationInstances
    extends AbstractUserAction {
        public ExplorationInstances() {
            super("Instances", UserAction.EXPLORATION);
        }

        public Consent disabled(View view) {
            NakedObject object = view.getContent().getNaked();
            return ConsentAbstract.allow((object != null ? 1 : 0) != 0);
        }

        public void execute(Workspace workspace, View view, Location at) {
            NakedObject object = view.getContent().getNaked();
            NakedObjectSpecification spec = object.getSpecification();
            NakedObject instances = NakedObjectsContext.getPersistenceSession().findInstances((Query)new QueryFindAllInstances(spec), QueryCardinality.MULTIPLE);
            Content content = Toolkit.getContentFactory().createRootContent(instances);
            View cloneView = Toolkit.getViewFactory().createWindow(content);
            cloneView.setLocation(at);
            workspace.addView(cloneView);
        }
    }
}

