/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd.viewer.content;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.commons.lang.ToString;
import org.nakedobjects.metamodel.consent.Allow;
import org.nakedobjects.metamodel.consent.Consent;
import org.nakedobjects.metamodel.consent.Veto;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.feature.OneToOneActionParameter;
import org.nakedobjects.plugins.dnd.ObjectParameter;
import org.nakedobjects.plugins.dnd.UserActionSet;
import org.nakedobjects.plugins.dnd.View;
import org.nakedobjects.plugins.dnd.Workspace;
import org.nakedobjects.plugins.dnd.viewer.action.AbstractUserAction;
import org.nakedobjects.plugins.dnd.viewer.content.AbstractObjectContent;
import org.nakedobjects.plugins.dnd.viewer.content.ActionHelper;
import org.nakedobjects.plugins.dnd.viewer.content.OptionFactory;
import org.nakedobjects.plugins.dnd.viewer.drawing.Location;

public class ObjectParameterImpl
extends AbstractObjectContent
implements ObjectParameter {
    private final NakedObject adapter;
    private final ActionHelper invocation;
    private final int index;
    private final NakedObject[] optionAdapters;
    private final OneToOneActionParameter nakedObjectActionParameter;

    public ObjectParameterImpl(OneToOneActionParameter nakedObjectActionParameter, NakedObject adapter, NakedObject[] optionAdapters, int i, ActionHelper invocation) {
        this.nakedObjectActionParameter = nakedObjectActionParameter;
        this.optionAdapters = optionAdapters;
        this.index = i;
        this.invocation = invocation;
        this.adapter = adapter;
    }

    public ObjectParameterImpl(ObjectParameterImpl content, NakedObject object) {
        this.nakedObjectActionParameter = content.nakedObjectActionParameter;
        this.optionAdapters = content.optionAdapters;
        this.index = content.index;
        this.invocation = content.invocation;
        this.adapter = object;
    }

    public Consent canClear() {
        return Allow.DEFAULT;
    }

    public Consent canSet(NakedObject dragSource) {
        if (dragSource.getSpecification().isOfType(this.getSpecification())) {
            return Allow.DEFAULT;
        }
        return new Veto(String.format("Object must be ", this.getSpecification().getShortName()));
    }

    public void clear() {
        this.setObject(null);
    }

    public void debugDetails(DebugString debug) {
        debug.appendln("name", (Object)this.getParameterName());
        debug.appendln("required", this.isRequired());
        debug.appendln("object", (Object)this.adapter);
    }

    public NakedObject getNaked() {
        return this.adapter;
    }

    public NakedObject getObject() {
        return this.adapter;
    }

    public NakedObject[] getOptions() {
        return this.optionAdapters;
    }

    public boolean isObject() {
        return true;
    }

    public boolean isRequired() {
        return !this.nakedObjectActionParameter.isOptional();
    }

    public boolean isPersistable() {
        return false;
    }

    public boolean isOptionEnabled() {
        return this.optionAdapters != null && this.optionAdapters.length > 0;
    }

    public boolean isTransient() {
        return this.adapter != null && this.adapter.isTransient();
    }

    public void contentMenuOptions(UserActionSet options) {
        if (this.adapter != null) {
            options.add(new AbstractUserAction("Clear parameter"){

                public void execute(Workspace workspace, View view, Location at) {
                    ObjectParameterImpl.this.clear();
                    view.getParent().invalidateContent();
                }
            });
            OptionFactory.addObjectMenuOptions(this.adapter, options);
        }
    }

    public void setObject(NakedObject object) {
        this.invocation.setParameter(this.index, object);
    }

    public String title() {
        return this.adapter == null ? "" : this.adapter.titleString();
    }

    public String toString() {
        ToString toString = new ToString((Object)this);
        toString.append("label", this.getParameterName());
        toString.append("required", this.isRequired());
        toString.append("spec", this.getSpecification().getFullName());
        toString.append("object", this.adapter == null ? "null" : this.adapter.titleString());
        return toString.toString();
    }

    public String getParameterName() {
        return this.nakedObjectActionParameter.getName();
    }

    public NakedObjectSpecification getSpecification() {
        return this.nakedObjectActionParameter.getSpecification();
    }

    public String getDescription() {
        String title = this.adapter == null ? "" : ": " + this.adapter.titleString();
        String name = this.getParameterName();
        NakedObjectSpecification specification = this.nakedObjectActionParameter.getSpecification();
        String specName = specification.getShortName();
        String type = name.indexOf(specName) == -1 ? " (" + specName + ")" : "";
        return name + type + title + " " + this.nakedObjectActionParameter.getDescription();
    }

    public String getHelp() {
        return this.invocation.getHelp();
    }

    public String getId() {
        return null;
    }
}

