/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd.viewer.content;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.commons.exceptions.UnexpectedCallException;
import org.nakedobjects.metamodel.consent.Consent;
import org.nakedobjects.metamodel.consent.Veto;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAction;
import org.nakedobjects.metamodel.spec.feature.NakedObjectActionConstants;
import org.nakedobjects.plugins.dnd.Content;
import org.nakedobjects.plugins.dnd.UserActionSet;
import org.nakedobjects.plugins.dnd.viewer.content.AbstractContent;
import org.nakedobjects.plugins.dnd.viewer.drawing.Image;
import org.nakedobjects.plugins.dnd.viewer.image.ImageFactory;

public class ServiceObject
extends AbstractContent {
    private final NakedObject adapter;

    public ServiceObject(NakedObject adapter) {
        this.adapter = adapter;
    }

    public Consent canClear() {
        return Veto.DEFAULT;
    }

    public Consent canSet(NakedObject dragSource) {
        return Veto.DEFAULT;
    }

    public void clear() {
        throw new NakedObjectException("Invalid call");
    }

    public void debugDetails(DebugString debug) {
        debug.appendln("service", (Object)this.adapter);
    }

    public NakedObject getNaked() {
        return this.adapter;
    }

    public String getDescription() {
        String specName = this.getSpecification().getSingularName();
        String objectTitle = this.getObject().titleString();
        return specName + (specName.equalsIgnoreCase(objectTitle) ? "" : ": " + objectTitle) + " " + this.getSpecification().getDescription();
    }

    public String getHelp() {
        return "";
    }

    public String getId() {
        return "";
    }

    public NakedObject getObject() {
        return this.adapter;
    }

    public NakedObject[] getOptions() {
        return null;
    }

    public NakedObjectSpecification getSpecification() {
        return this.adapter.getSpecification();
    }

    public boolean isObject() {
        return false;
    }

    public boolean isOptionEnabled() {
        return false;
    }

    public boolean isTransient() {
        return this.adapter != null && this.adapter.isTransient();
    }

    public void setObject(NakedObject object) {
        throw new NakedObjectException("Invalid call");
    }

    public String title() {
        return this.adapter.titleString();
    }

    public String toString() {
        return "Service Object [" + this.adapter + "]";
    }

    public String windowTitle() {
        return (this.isTransient() ? "UNSAVED " : "") + this.getSpecification().getSingularName();
    }

    public Consent canDrop(Content sourceContent) {
        NakedObjectAction action = this.actionFor(sourceContent);
        if (action == null) {
            return Veto.DEFAULT;
        }
        NakedObject source = sourceContent.getNaked();
        Consent parameterSetValid = action.isProposedArgumentSetValid(this.adapter, new NakedObject[]{source});
        parameterSetValid.setDescription("Execute '" + action.getName() + "' with " + source.titleString());
        return parameterSetValid;
    }

    private NakedObjectAction actionFor(Content sourceContent) {
        NakedObjectAction action = this.adapter.getSpecification().getObjectAction(NakedObjectActionConstants.USER, null, new NakedObjectSpecification[]{sourceContent.getSpecification()});
        return action;
    }

    public NakedObject drop(Content sourceContent) {
        NakedObjectAction action = this.actionFor(sourceContent);
        NakedObject source = sourceContent.getNaked();
        return action.execute(this.adapter, new NakedObject[]{source});
    }

    public String getIconName() {
        NakedObject object = this.getObject();
        return object == null ? null : object.getIconName();
    }

    public Image getIconPicture(int iconHeight) {
        NakedObject nakedObject = this.getObject();
        NakedObjectSpecification specification = nakedObject.getSpecification();
        Image icon = ImageFactory.getInstance().loadIcon(specification, iconHeight, null);
        return icon;
    }

    public void parseTextEntry(String entryText) {
        throw new UnexpectedCallException();
    }

    public void viewMenuOptions(UserActionSet options) {
    }
}

