/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd.viewer.debug;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.debug.DebugInfo;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.plugins.dnd.CollectionContent;
import org.nakedobjects.plugins.dnd.Content;
import org.nakedobjects.plugins.dnd.ObjectContent;
import org.nakedobjects.plugins.dnd.View;
import org.nakedobjects.plugins.dnd.viewer.debug.DebugCanvas;
import org.nakedobjects.plugins.dnd.viewer.drawing.Bounds;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.util.Dump;

public class DebugView
implements DebugInfo {
    private final View view;

    public DebugView(View display) {
        this.view = display;
    }

    public void debugData(DebugString debug) {
        debug.append((Object)this.view.getView());
        debug.blankLine();
        debug.blankLine();
        debug.appendTitle("VIEW");
        this.view.debug(debug);
        debug.appendln();
        Content content = this.view.getContent();
        debug.appendTitle("CONTENT");
        if (content != null) {
            String type = content.getClass().getName();
            type = type.substring(type.lastIndexOf(46) + 1);
            debug.appendln("Content", (Object)type);
            content.debugDetails(debug);
            debug.indent();
            debug.appendln("Icon name", (Object)content.getIconName());
            debug.appendln("Icon ", (Object)content.getIconPicture(32));
            debug.appendln("Window title", (Object)content.windowTitle());
            debug.appendln("Persistable", content.isPersistable());
            debug.appendln("Object", content.isObject());
            debug.appendln("Collection", content.isCollection());
            debug.appendln("Parseable", content.isTextParseable());
            debug.unindent();
        } else {
            debug.appendln("Content", (Object)"none");
        }
        debug.blankLine();
        if (content instanceof ObjectContent) {
            NakedObject object = ((ObjectContent)content).getObject();
            this.dumpObject(object, debug);
            debug.blankLine();
            this.dumpSpecification(object, debug);
            debug.blankLine();
            this.dumpGraph(object, debug);
        } else if (content instanceof CollectionContent) {
            NakedObject collection = ((CollectionContent)((Object)content)).getCollection();
            debug.blankLine();
            this.dumpObject(collection, debug);
            this.dumpSpecification(collection, debug);
            debug.blankLine();
            this.dumpGraph(collection, debug);
        }
        debug.append((Object)"\n\nDRAWING\n");
        debug.append((Object)"------\n");
        this.view.draw(new DebugCanvas(debug, new Bounds(this.view.getBounds())));
    }

    public String debugTitle() {
        return "Debug: " + this.view + this.view == null ? "" : "/" + this.view.getContent();
    }

    public void dumpGraph(NakedObject object, DebugString info) {
        if (object != null) {
            info.appendTitle("GRAPH");
            Dump.graph((NakedObject)object, (DebugString)info, (AuthenticationSession)NakedObjectsContext.getAuthenticationSession());
        }
    }

    public void dumpObject(NakedObject object, DebugString info) {
        if (object != null) {
            info.appendTitle("OBJECT");
            Dump.adapter((NakedObject)object, (DebugString)info);
        }
    }

    private void dumpSpecification(NakedObject object, DebugString info) {
        if (object != null) {
            info.appendTitle("SPECIFICATION");
            Dump.specification((NakedObject)object, (DebugString)info);
        }
    }
}

