/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd.viewer.drawing;

import org.nakedobjects.plugins.dnd.viewer.drawing.Offset;

public class Location {
    int x;
    int y;

    public Location() {
        this.x = 0;
        this.y = 0;
    }

    public Location(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public Location(Location location) {
        this.x = location.x;
        this.y = location.y;
    }

    public void add(int x, int y) {
        this.move(x, y);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Location) {
            Location object = (Location)obj;
            return object.x == this.x && object.y == this.y;
        }
        return false;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void move(int dx, int dy) {
        this.x += dx;
        this.y += dy;
    }

    public Offset offsetFrom(Location location) {
        Offset offset = new Offset(this.x - location.x, this.y - location.y);
        return offset;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void subtract(int x, int y) {
        this.move(-x, -y);
    }

    public void subtract(Location location) {
        this.move(-location.x, -location.y);
    }

    public void subtract(Offset offset) {
        this.move(-offset.getDeltaX(), -offset.getDeltaY());
    }

    public String toString() {
        return this.x + "," + this.y;
    }

    public void translate(Location offset) {
        this.move(offset.x, offset.y);
    }

    public void translate(Offset offset) {
        this.move(offset.getDeltaX(), offset.getDeltaY());
    }
}

