/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd.viewer.list;

import org.nakedobjects.plugins.dnd.Canvas;
import org.nakedobjects.plugins.dnd.Content;
import org.nakedobjects.plugins.dnd.Toolkit;
import org.nakedobjects.plugins.dnd.ViewAxis;
import org.nakedobjects.plugins.dnd.ViewSpecification;
import org.nakedobjects.plugins.dnd.viewer.drawing.Color;
import org.nakedobjects.plugins.dnd.viewer.drawing.Text;
import org.nakedobjects.plugins.dnd.viewer.list.HistogramAxis;
import org.nakedobjects.plugins.dnd.viewer.view.simple.ObjectView;

class HistogramBar
extends ObjectView {
    protected HistogramBar(Content content, ViewSpecification specification, ViewAxis axis) {
        super(content, specification, axis);
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        int y = 0;
        int height = this.getSize().getHeight() - 5;
        Text text = Toolkit.getText("text.label");
        Color color = Toolkit.getColor("color.primary1");
        canvas.drawText(this.getContent().title(), 0, height / 2 + text.getAscent() / 2, color, text);
        HistogramAxis axis = (HistogramAxis)this.getViewAxis();
        double length = (double)(this.getSize().getWidth() - 160) * axis.getLengthFor(this.getContent());
        canvas.drawSolidRectangle(160, y, (int)length, height, Toolkit.getColor("color.primary2"));
        canvas.drawRectangle(160, y, (int)length, height, Toolkit.getColor("color.black"));
    }
}

