/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd.viewer.lookup;

import org.nakedobjects.plugins.dnd.Canvas;
import org.nakedobjects.plugins.dnd.Click;
import org.nakedobjects.plugins.dnd.Toolkit;
import org.nakedobjects.plugins.dnd.View;
import org.nakedobjects.plugins.dnd.viewer.border.AbstractViewDecorator;
import org.nakedobjects.plugins.dnd.viewer.drawing.Color;
import org.nakedobjects.plugins.dnd.viewer.drawing.Size;
import org.nakedobjects.plugins.dnd.viewer.lookup.DropDownAxis;
import org.nakedobjects.plugins.dnd.viewer.lookup.OptionContent;

class DropDownSelection
extends AbstractViewDecorator {
    protected DropDownSelection(View wrappedView) {
        super(wrappedView);
    }

    public void draw(Canvas canvas) {
        if (this.getState().isViewIdentified()) {
            Color color = Toolkit.getColor("color.secondary3");
            canvas.clearBackground(this, color);
        }
        canvas.offset(HPADDING, 0);
        super.draw(canvas);
    }

    public void entered() {
        this.getState().setContentIdentified();
        this.getState().setViewIdentified();
        this.wrappedView.entered();
        this.markDamaged();
    }

    public void exited() {
        this.getState().clearObjectIdentified();
        this.getState().clearViewIdentified();
        this.wrappedView.exited();
        this.markDamaged();
    }

    public void firstClick(Click click) {
        DropDownAxis axis = (DropDownAxis)this.getViewAxis();
        axis.setSelection((OptionContent)this.getContent());
        View view = axis.getOriginalView();
        view.getParent().updateView();
        view.getParent().invalidateContent();
    }

    public Size getRequiredSize(Size maximumSize) {
        Size size = super.getRequiredSize(maximumSize);
        size.extendWidth(HPADDING * 2);
        return size;
    }
}

