/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd.viewer.table;

import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.plugins.dnd.Canvas;
import org.nakedobjects.plugins.dnd.Click;
import org.nakedobjects.plugins.dnd.ContentDrag;
import org.nakedobjects.plugins.dnd.Drag;
import org.nakedobjects.plugins.dnd.DragStart;
import org.nakedobjects.plugins.dnd.Toolkit;
import org.nakedobjects.plugins.dnd.View;
import org.nakedobjects.plugins.dnd.ViewAreaType;
import org.nakedobjects.plugins.dnd.ViewDrag;
import org.nakedobjects.plugins.dnd.viewer.border.AbstractBorder;
import org.nakedobjects.plugins.dnd.viewer.drawing.Color;
import org.nakedobjects.plugins.dnd.viewer.drawing.Location;
import org.nakedobjects.plugins.dnd.viewer.drawing.Offset;
import org.nakedobjects.plugins.dnd.viewer.drawing.Size;
import org.nakedobjects.plugins.dnd.viewer.drawing.Text;
import org.nakedobjects.plugins.dnd.viewer.table.TableAxis;
import org.nakedobjects.plugins.dnd.viewer.view.graphic.IconGraphic;
import org.nakedobjects.plugins.dnd.viewer.view.simple.DragViewOutline;
import org.nakedobjects.plugins.dnd.viewer.view.text.ObjectTitleText;
import org.nakedobjects.plugins.dnd.viewer.view.text.TitleText;

public class TableRowBorder
extends AbstractBorder {
    private static final int BORDER = 13;
    private final int baseline;
    private final IconGraphic icon;
    private final TitleText title;

    public TableRowBorder(View wrappedRow) {
        super(wrappedRow);
        Text text = Toolkit.getText("text.normal");
        this.icon = new IconGraphic((View)this, text);
        this.title = new ObjectTitleText(this, text);
        this.baseline = this.icon.getBaseline();
        this.left = this.requiredTitleWidth() + 13;
        ((TableAxis)wrappedRow.getViewAxis()).ensureOffset(this.left);
    }

    public void debugDetails(DebugString debug) {
        debug.appendln("RowBorder " + this.left + " pixels");
    }

    public Drag dragStart(DragStart drag) {
        TableAxis axis;
        int left;
        int x = drag.getLocation().getX();
        if (x < (left = (axis = (TableAxis)this.getViewAxis()).getHeaderOffset()) - 13) {
            View dragOverlay = Toolkit.getViewFactory().getContentDragSpecification().createView(this.getContent(), null);
            return new ContentDrag(this, drag.getLocation(), dragOverlay);
        }
        if (x < left) {
            DragViewOutline dragOverlay = new DragViewOutline(this.getView());
            return new ViewDrag(this, new Offset(drag.getLocation()), dragOverlay);
        }
        return super.dragStart(drag);
    }

    public void draw(Canvas canvas) {
        int baseline = this.getBaseline();
        TableAxis axis = (TableAxis)this.getViewAxis();
        int width = axis.getHeaderOffset();
        Size s = this.getSize();
        Canvas subcanvas = canvas.createSubcanvas(0, 0, width, s.getHeight());
        int offset = HPADDING;
        this.icon.draw(subcanvas, offset, baseline);
        this.title.draw(subcanvas, offset += this.icon.getSize().getWidth() + HPADDING + 0 + HPADDING, baseline, this.getLeft() - offset);
        int columns = axis.getColumnCount();
        int x = -1;
        Color secondary1 = Toolkit.getColor("color.secondary1");
        canvas.drawLine((x += axis.getHeaderOffset()) - 1, 0, x - 1, s.getHeight() - 1, secondary1);
        canvas.drawLine(x, 0, x, s.getHeight() - 1, secondary1);
        for (int i = 0; i < columns; ++i) {
            canvas.drawLine(x += axis.getColumnWidth(i), 0, x, s.getHeight() - 1, secondary1);
        }
        int y = s.getHeight() - 1;
        Color secondary2 = Toolkit.getColor("color.secondary2");
        canvas.drawLine(0, y, s.getWidth(), y, secondary2);
        if (this.getState().isObjectIdentified()) {
            int xExtent = width - 1;
            canvas.drawLine(xExtent - 13, this.top, xExtent - 13, this.top + s.getHeight() - 1, secondary2);
            canvas.drawSolidRectangle(xExtent - 13 + 1, this.top, 11, s.getHeight() - 2 * this.top - 1, Toolkit.getColor("color.secondary3"));
        }
        super.draw(canvas);
    }

    public int getBaseline() {
        return this.baseline;
    }

    protected int getLeft() {
        return ((TableAxis)this.wrappedView.getViewAxis()).getHeaderOffset();
    }

    protected int requiredTitleWidth() {
        return HPADDING + this.icon.getSize().getWidth() + HPADDING + this.title.getSize().getWidth() + HPADDING;
    }

    public void entered() {
        this.getState().setContentIdentified();
        this.getState().setViewIdentified();
        this.wrappedView.entered();
        this.markDamaged();
    }

    public void exited() {
        this.getState().clearObjectIdentified();
        this.getState().clearViewIdentified();
        this.wrappedView.exited();
        this.markDamaged();
    }

    public void secondClick(Click click) {
        TableAxis axis = (TableAxis)this.getViewAxis();
        int left = axis.getHeaderOffset();
        int x = click.getLocation().getX();
        if (x <= left) {
            Location location = this.getAbsoluteLocation();
            location.translate(click.getLocation());
            View openWindow = Toolkit.getViewFactory().createWindow(this.getContent());
            openWindow.setLocation(location);
            this.getWorkspace().addView(openWindow);
        } else {
            super.secondClick(click);
        }
    }

    public String toString() {
        return "RowBorder/" + this.wrappedView;
    }

    public ViewAreaType viewAreaType(Location mouseLocation) {
        if (mouseLocation.getX() <= this.left) {
            return ViewAreaType.CONTENT;
        }
        if (mouseLocation.getX() >= this.getSize().getWidth() - this.right) {
            return ViewAreaType.VIEW;
        }
        return super.viewAreaType(mouseLocation);
    }
}

