/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd.viewer.tree;

import org.nakedobjects.plugins.dnd.Canvas;
import org.nakedobjects.plugins.dnd.Toolkit;
import org.nakedobjects.plugins.dnd.View;
import org.nakedobjects.plugins.dnd.viewer.basic.ResizeBorder;
import org.nakedobjects.plugins.dnd.viewer.drawing.Color;
import org.nakedobjects.plugins.dnd.viewer.drawing.DrawingUtil;
import org.nakedobjects.plugins.dnd.viewer.drawing.Size;
import org.nakedobjects.runtime.context.NakedObjectsContext;

public class ViewResizeBorder
extends ResizeBorder {
    public static final int BORDER_WIDTH = NakedObjectsContext.getConfiguration().getInteger("nakedobjects.viewer.dnd.tree-resize-border", 7);

    public ViewResizeBorder(View view) {
        super(view, 2, BORDER_WIDTH, 2);
    }

    protected void drawResizeBorder(Canvas canvas, Size size) {
        int h2;
        int h1;
        int x = this.getSize().getWidth() - BORDER_WIDTH;
        int height = this.getSize().getHeight() - 1;
        if (height < (h1 = 30) + (h2 = 10) * 2) {
            h1 = Math.min(0, height - h2 * 2);
        } else {
            h2 = (height - h1) / 2;
        }
        boolean hasFocus = this.getParent().containsFocus();
        Color borderColor = hasFocus ? Toolkit.getColor("color.primary3") : Toolkit.getColor("color.secondary3");
        canvas.drawSolidRectangle(x, 0, BORDER_WIDTH, height, borderColor);
        Color secondary2 = Toolkit.getColor("color.secondary2");
        canvas.drawRectangle(x, -1, BORDER_WIDTH, height + 2, secondary2);
        Color color = hasFocus ? Toolkit.getColor("color.primary2") : secondary2;
        DrawingUtil.drawHatching(canvas, x + 1, h2, BORDER_WIDTH - 2, h1, color, Toolkit.getColor("color.white"));
    }
}

