/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd.viewer.view.calendar;

import org.nakedobjects.plugins.dnd.Canvas;
import org.nakedobjects.plugins.dnd.Click;
import org.nakedobjects.plugins.dnd.Toolkit;
import org.nakedobjects.plugins.dnd.viewer.border.AbstractBorder;
import org.nakedobjects.plugins.dnd.viewer.drawing.Location;
import org.nakedobjects.plugins.dnd.viewer.view.calendar.CalendarBorderTab;
import org.nakedobjects.plugins.dnd.viewer.view.calendar.CalendarTemplate;

public class CalendarBorder
extends AbstractBorder {
    private static final int HEIGHT = 20;
    private final CalendarBorderTab[] tabs;
    private int over;
    private int selected;

    protected CalendarBorder(CalendarTemplate view, CalendarBorderTab[] tabs) {
        super(view);
        this.tabs = tabs;
        this.top = 20;
    }

    public void draw(Canvas canvas) {
        int width = this.tabWidth();
        for (int i = 0; i < this.tabs.length; ++i) {
            Canvas tabcanvas = canvas.createSubcanvas(i * width, 0, width, 20);
            if (i == this.selected) {
                tabcanvas.drawSolidRectangle(0, 0, width + 1, 25, Toolkit.getColor("color.primary3"));
            } else if (i == this.over) {
                tabcanvas.drawSolidRectangle(0, 0, width + 1, 25, Toolkit.getColor("color.secondary3"));
            }
            this.tabs[i].draw(tabcanvas, width);
            tabcanvas.drawRoundedRectangle(0, 0, width + 1, 25, 5, 5, Toolkit.getColor("color.black"));
        }
        super.draw(canvas);
    }

    public void firstClick(Click click) {
        if (this.overContent(click.getLocation())) {
            super.firstClick(click);
        } else {
            int x = click.getLocation().getX();
            int i = this.overTab(x);
            click.subtract(i * this.tabWidth(), 0);
            if (this.tabs[i].select(click, (CalendarTemplate)this.getView())) {
                this.selected = i;
            }
        }
    }

    private int overTab(int x) {
        int width = this.tabWidth();
        int i = x / width;
        return i;
    }

    private int tabWidth() {
        return this.getSize().getWidth() / this.tabs.length;
    }

    public void mouseMoved(Location at) {
        if (this.overContent(at)) {
            super.mouseMoved(at);
            this.over = -1;
            this.markDamaged();
        } else {
            this.over = this.overTab(at.getX());
            this.markDamaged();
        }
    }

    public void exited() {
        super.exited();
        this.over = -1;
        this.markDamaged();
    }
}

