/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd.viewer.view.calendar;

import java.util.List;
import org.nakedobjects.metamodel.facets.hide.HiddenFacet;
import org.nakedobjects.metamodel.facets.value.DateValueFacet;
import org.nakedobjects.metamodel.spec.feature.OneToOneAssociation;
import org.nakedobjects.plugins.dnd.CollectionContent;
import org.nakedobjects.plugins.dnd.Content;
import org.nakedobjects.plugins.dnd.SubviewSpec;
import org.nakedobjects.plugins.dnd.Toolkit;
import org.nakedobjects.plugins.dnd.View;
import org.nakedobjects.plugins.dnd.ViewAxis;
import org.nakedobjects.plugins.dnd.ViewRequirement;
import org.nakedobjects.plugins.dnd.viewer.border.ObjectBorder;
import org.nakedobjects.plugins.dnd.viewer.builder.AbstractCompositeViewSpecification;
import org.nakedobjects.plugins.dnd.viewer.builder.CollectionElementBuilder;
import org.nakedobjects.plugins.dnd.viewer.view.calendar.CalendarAxis;
import org.nakedobjects.plugins.dnd.viewer.view.calendar.CalendarBorder;
import org.nakedobjects.plugins.dnd.viewer.view.calendar.CalendarBorderTab;
import org.nakedobjects.plugins.dnd.viewer.view.calendar.CalendarLayout;
import org.nakedobjects.plugins.dnd.viewer.view.calendar.CalendarTemplate;
import org.nakedobjects.plugins.dnd.viewer.view.calendar.MonthDisplay;
import org.nakedobjects.plugins.dnd.viewer.view.calendar.NamedCalendarBorderTab;
import org.nakedobjects.plugins.dnd.viewer.view.calendar.WeekDisplay;
import org.nakedobjects.plugins.dnd.viewer.view.graphic.IconGraphic;
import org.nakedobjects.plugins.dnd.viewer.view.simple.Icon;
import org.nakedobjects.plugins.dnd.viewer.view.text.ObjectTitleText;

public class CalendarSpecification
extends AbstractCompositeViewSpecification
implements SubviewSpec {
    public CalendarSpecification() {
        this.builder = new CalendarLayout(new CollectionElementBuilder(this));
    }

    public boolean canDisplay(Content content, ViewRequirement requirement) {
        boolean openCollection;
        boolean bl = openCollection = content instanceof CollectionContent && requirement.is(4);
        if (openCollection) {
            List propertyList = ((CollectionContent)((Object)content)).getElementSpecification().getPropertyList();
            for (OneToOneAssociation association : propertyList) {
                if (association.containsFacet(HiddenFacet.class) || !association.getSpecification().containsFacet(DateValueFacet.class)) continue;
                return true;
            }
        }
        return false;
    }

    protected ViewAxis axis(Content content) {
        return new CalendarAxis();
    }

    protected View decorateView(View view) {
        MonthDisplay monthDisplay = new MonthDisplay();
        WeekDisplay weekDisplay = new WeekDisplay();
        CalendarTemplate calendarTemplate = new CalendarTemplate(view, monthDisplay);
        CalendarBorderTab[] tabs = new CalendarBorderTab[]{new NamedCalendarBorderTab("Month", monthDisplay), new NamedCalendarBorderTab("Week", weekDisplay), new NamedCalendarBorderTab("Day", null)};
        CalendarBorder calendarBorder = new CalendarBorder(calendarTemplate, tabs);
        return calendarBorder;
    }

    public String getName() {
        return "Calendar";
    }

    public boolean isOpen() {
        return true;
    }

    public boolean isReplaceable() {
        return true;
    }

    public boolean isSubView() {
        return false;
    }

    public View createSubview(Content content, ViewAxis axis, int fieldNumber) {
        Icon icon = new Icon(content, this, axis);
        icon.setTitle(new ObjectTitleText(icon, Toolkit.getText("text.normal")));
        icon.setSelectedIcon(new IconGraphic((View)icon, 24));
        icon.setVertical(true);
        return new ObjectBorder(icon);
    }
}

