/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd.viewer.view.calendar;

import java.util.Calendar;
import java.util.Date;
import org.nakedobjects.plugins.dnd.Canvas;
import org.nakedobjects.plugins.dnd.Click;
import org.nakedobjects.plugins.dnd.ContentDrag;
import org.nakedobjects.plugins.dnd.View;
import org.nakedobjects.plugins.dnd.viewer.drawing.Location;
import org.nakedobjects.plugins.dnd.viewer.drawing.Size;
import org.nakedobjects.plugins.dnd.viewer.view.calendar.CalendarConstants;
import org.nakedobjects.plugins.dnd.viewer.view.calendar.CalendarDisplay;

public class WeekDisplay
implements CalendarDisplay {
    public void draw(Canvas canvas, Size size) {
        this.weekGrid(canvas, size);
    }

    public boolean drop(ContentDrag drag, Size size) {
        return false;
    }

    private void weekGrid(Canvas canvas, Size size) {
        int width = size.getWidth() / 7;
        int height = size.getHeight();
        int y = CalendarConstants.style.getTextHeight();
        canvas.drawSolidRectangle(width * 5, 0, width * 2, height, CalendarConstants.weekendColor);
        canvas.drawLine(0, y + 4, width * 7, y + 4, CalendarConstants.lineColor);
        for (int i = 0; i < 7; ++i) {
            int x = i * width;
            canvas.drawLine(x, 0, x, height, CalendarConstants.lineColor);
            String day = CalendarConstants.days[i];
            x = x + width / 2 - CalendarConstants.style.stringWidth(day) / 2;
            canvas.drawText(day, x + 5, y, CalendarConstants.textColor, CalendarConstants.style);
        }
    }

    public void firstClick(Click click, Size size) {
    }

    public Size getBlockSize(Size size) {
        return new Size(size.getWidth() / 7, size.getHeight());
    }

    public void layoutDate(View v, Date date, int width, int height) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int day = c.get(5);
        int col = (day - 1) % 7;
        int x = width * col;
        v.setLocation(new Location(x, 30));
        v.setSize(new Size(width, height));
    }

    public Size getRequiredSize() {
        return new Size(560, 160);
    }
}

