/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd.viewer.view.field;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.commons.exceptions.NotYetImplementedException;
import org.nakedobjects.metamodel.commons.lang.ToString;
import org.nakedobjects.metamodel.consent.Consent;
import org.nakedobjects.plugins.dnd.BackgroundTask;
import org.nakedobjects.plugins.dnd.BackgroundThread;
import org.nakedobjects.plugins.dnd.Canvas;
import org.nakedobjects.plugins.dnd.Content;
import org.nakedobjects.plugins.dnd.InternalDrag;
import org.nakedobjects.plugins.dnd.KeyboardAction;
import org.nakedobjects.plugins.dnd.Toolkit;
import org.nakedobjects.plugins.dnd.UserActionSet;
import org.nakedobjects.plugins.dnd.View;
import org.nakedobjects.plugins.dnd.ViewAreaType;
import org.nakedobjects.plugins.dnd.ViewAxis;
import org.nakedobjects.plugins.dnd.ViewSpecification;
import org.nakedobjects.plugins.dnd.viewer.drawing.Image;
import org.nakedobjects.plugins.dnd.viewer.drawing.Location;
import org.nakedobjects.plugins.dnd.viewer.drawing.Padding;
import org.nakedobjects.plugins.dnd.viewer.image.ImageFactory;
import org.nakedobjects.plugins.dnd.viewer.view.field.ClearValueOption;
import org.nakedobjects.plugins.dnd.viewer.view.field.CopyValueOption;
import org.nakedobjects.plugins.dnd.viewer.view.field.PasteValueOption;
import org.nakedobjects.plugins.dnd.viewer.view.simple.AbstractView;

public abstract class AbstractField
extends AbstractView {
    protected static final int TEXT_WIDTH = 20;
    private boolean identified;

    protected AbstractField(Content content, ViewSpecification design, ViewAxis axis) {
        super(content, design, axis);
    }

    public boolean canFocus() {
        return this.canChangeValue().isAllowed();
    }

    protected boolean provideClearCopyPaste() {
        return false;
    }

    protected boolean cantClear() {
        return true;
    }

    protected void clear() {
    }

    protected void copyToClipboard() {
    }

    protected void pasteFromClipboard() {
    }

    public void drag(InternalDrag drag) {
    }

    public void dragCancel(InternalDrag drag) {
    }

    public View dragFrom(Location location) {
        return null;
    }

    public void dragTo(InternalDrag drag) {
    }

    public void draw(Canvas canvas) {
        Image image;
        if (this.getState().isActive()) {
            canvas.clearBackground(this, Toolkit.getColor("color.identified"));
        }
        if (this.getState().isOutOfSynch()) {
            canvas.clearBackground(this, Toolkit.getColor("color.out-of-sync"));
        }
        if (this.getState().isInvalid() && (image = ImageFactory.getInstance().loadIcon("invalid-entry", 12, null)) != null) {
            canvas.drawImage(image, this.getSize().getWidth() - 16, 2);
        }
        super.draw(canvas);
    }

    public void entered() {
        super.entered();
        this.identified = true;
        Consent changable = this.canChangeValue();
        if (changable.isVetoed()) {
            this.getFeedbackManager().setViewDetail(changable.getReason());
        }
        this.markDamaged();
    }

    public void exited() {
        super.exited();
        this.identified = false;
        this.markDamaged();
    }

    public boolean getIdentified() {
        return this.identified;
    }

    public Padding getPadding() {
        return new Padding(0, 0, 0, 0);
    }

    public View getRoot() {
        throw new NotYetImplementedException();
    }

    String getSelectedText() {
        return "";
    }

    public boolean hasFocus() {
        return this.getViewManager().hasFocus(this.getView());
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean indicatesForView(Location mouseLocation) {
        return false;
    }

    public void keyPressed(KeyboardAction key) {
    }

    public void keyReleased(int keyCode, int modifiers) {
    }

    public void keyTyped(char keyCode) {
    }

    public void contentMenuOptions(UserActionSet options) {
        if (this.provideClearCopyPaste()) {
            options.add(new CopyValueOption(this));
            options.add(new PasteValueOption(this));
            options.add(new ClearValueOption(this));
        }
        if (this.getView().getSpecification().isReplaceable()) {
            this.replaceOptions(Toolkit.getViewFactory().valueViews(this.getContent(), this), options);
        }
        super.contentMenuOptions(options);
        options.setColor(Toolkit.getColor("color.background.menu.value"));
    }

    protected final void initiateSave(final boolean moveToNextField) {
        BackgroundThread.run(this, new BackgroundTask(){

            public void execute() {
                AbstractField.this.save();
                AbstractField.this.getParent().updateView();
                AbstractField.this.invalidateLayout();
                if (moveToNextField) {
                    AbstractField.this.getFocusManager().focusNextView();
                }
            }

            public String getName() {
                return "Save field";
            }

            public String getDescription() {
                return "Saving " + AbstractField.this.getContent().windowTitle();
            }
        });
    }

    protected abstract void save();

    public String toString() {
        ToString str = new ToString((Object)this, this.getId());
        str.append("location", (Object)this.getLocation());
        NakedObject nakedObject = this.getContent().getNaked();
        str.append("object", nakedObject == null ? "" : nakedObject.getObject());
        return str.toString();
    }

    public ViewAreaType viewAreaType(Location mouseLocation) {
        return ViewAreaType.INTERNAL;
    }

    public int getBaseline() {
        return Toolkit.defaultBaseline();
    }
}

