/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd.viewer.view.field;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.consent.Consent;
import org.nakedobjects.metamodel.consent.Veto;
import org.nakedobjects.plugins.dnd.View;
import org.nakedobjects.plugins.dnd.Workspace;
import org.nakedobjects.plugins.dnd.viewer.drawing.Location;
import org.nakedobjects.plugins.dnd.viewer.view.field.AbstractField;
import org.nakedobjects.plugins.dnd.viewer.view.field.AbstractValueOption;

public class ClearValueOption
extends AbstractValueOption {
    public ClearValueOption(AbstractField field) {
        super(field, "Clear");
    }

    public String getDescription(View view) {
        return "Clear field";
    }

    public Consent disabled(View view) {
        NakedObject value = this.getValue(view);
        Consent consent = view.canChangeValue();
        if (consent.isVetoed()) {
            return consent;
        }
        if (this.field.cantClear()) {
            return new Veto(String.format("Can't clear %s values", value.getSpecification().getShortName()));
        }
        if (value == null || this.isEmpty(view)) {
            return new Veto("Field is already empty");
        }
        return consent.setDescription(String.format("Clear value ", value.titleString()));
    }

    public void execute(Workspace frame, View view, Location at) {
        this.field.clear();
    }

    public String toString() {
        return "ClearValueOption";
    }
}

