/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd.viewer.view.field;

import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.facets.value.ImageValueFacet;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.plugins.dnd.Canvas;
import org.nakedobjects.plugins.dnd.Content;
import org.nakedobjects.plugins.dnd.FieldContent;
import org.nakedobjects.plugins.dnd.KeyboardAction;
import org.nakedobjects.plugins.dnd.OneToOneField;
import org.nakedobjects.plugins.dnd.Toolkit;
import org.nakedobjects.plugins.dnd.UserActionSet;
import org.nakedobjects.plugins.dnd.View;
import org.nakedobjects.plugins.dnd.ViewAxis;
import org.nakedobjects.plugins.dnd.ViewRequirement;
import org.nakedobjects.plugins.dnd.ViewSpecification;
import org.nakedobjects.plugins.dnd.Workspace;
import org.nakedobjects.plugins.dnd.viewer.action.AbstractUserAction;
import org.nakedobjects.plugins.dnd.viewer.builder.AbstractFieldSpecification;
import org.nakedobjects.plugins.dnd.viewer.drawing.Color;
import org.nakedobjects.plugins.dnd.viewer.drawing.Location;
import org.nakedobjects.plugins.dnd.viewer.drawing.Size;
import org.nakedobjects.plugins.dnd.viewer.image.AwtImage;
import org.nakedobjects.plugins.dnd.viewer.view.field.AbstractField;

public class ImageField
extends AbstractField {
    private static final Logger LOG = Logger.getLogger(ImageField.class);
    private static final MediaTracker mt = new MediaTracker(new java.awt.Canvas());

    public ImageField(Content content, ViewSpecification specification, ViewAxis axis) {
        super(content, specification, axis);
    }

    public boolean canFocus() {
        return true;
    }

    public void contentMenuOptions(UserActionSet options) {
        super.contentMenuOptions(options);
        options.add(new AbstractUserAction("Load image from file..."){

            public void execute(Workspace workspace, View view, Location at) {
                String file = ImageField.this.getViewManager().selectFilePath("Load image", ".");
                ImageField.this.loadImageFromFile(file);
            }
        });
    }

    private void copy() {
    }

    public void draw(Canvas canvas) {
        ImageValueFacet facet;
        Image image;
        Color color = this.hasFocus() ? Toolkit.getColor("color.primary1") : (this.getParent().getState().isObjectIdentified() ? Toolkit.getColor("color.identified") : (this.getParent().getState().isRootViewIdentified() ? Toolkit.getColor("color.primary2") : Toolkit.getColor("color.secondary1")));
        int top = 0;
        int left = 0;
        Size size = this.getSize();
        int w = size.getWidth() - 1;
        int h = size.getHeight() - 1;
        canvas.drawRectangle(left, top, w, h, color);
        ++left;
        ++top;
        --w;
        --h;
        NakedObject value = this.getContent().getNaked();
        if (value != null && (image = (facet = (ImageValueFacet)value.getSpecification().getFacet(ImageValueFacet.class)).getImage(value)) != null) {
            Size imageSize = new Size(facet.getWidth(value), facet.getHeight(value));
            if (imageSize.getWidth() <= w && imageSize.getHeight() <= h) {
                canvas.drawImage(new AwtImage(image), left, top);
            } else {
                canvas.drawImage(new AwtImage(image), left, top, w, h);
            }
        }
    }

    public int getBaseline() {
        return VPADDING + Toolkit.getText("text.normal").getAscent();
    }

    public Size getMaximumSize() {
        Size size = new Size(60, 60);
        return size;
    }

    public Size getRequiredSize(Size maximumSize) {
        NakedObject value = this.getContent().getNaked();
        if (value == null) {
            return super.getRequiredSize(maximumSize);
        }
        ImageValueFacet facet = (ImageValueFacet)value.getSpecification().getFacet(ImageValueFacet.class);
        int width = Math.min(120, Math.max(32, facet.getWidth(value)));
        int height = Math.min(120, Math.max(32, facet.getHeight(value)));
        return new Size(width, height);
    }

    public void keyPressed(KeyboardAction key) {
        if (this.canChangeValue().isVetoed()) {
            return;
        }
        int keyCode = key.getKeyCode();
        if (keyCode == 17 || keyCode == 16 || keyCode == 18) {
            return;
        }
        int modifiers = key.getModifiers();
        boolean ctrl = (modifiers & 2) > 0;
        switch (keyCode) {
            case 86: {
                if (!ctrl) break;
                key.consume();
                this.pasteFromClipboard();
                break;
            }
            case 67: {
                if (!ctrl) break;
                key.consume();
                this.copy();
            }
        }
    }

    private void loadImage(Image image) {
        mt.addImage(image, 1);
        try {
            mt.waitForAll();
        }
        catch (InterruptedException e) {
            throw new NakedObjectException((Throwable)e);
        }
        ImageValueFacet facet = (ImageValueFacet)((FieldContent)this.getContent()).getSpecification().getFacet(ImageValueFacet.class);
        NakedObject object = facet.createValue(image);
        ((OneToOneField)this.getContent()).setObject(object);
        this.invalidateLayout();
    }

    private void loadImageFromFile(String filename) {
        Image image = java.awt.Toolkit.getDefaultToolkit().getImage(filename);
        this.loadImage(image);
    }

    protected void pasteFromClipboard() {
        Clipboard cb = java.awt.Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable content = cb.getContents(this);
        try {
            if (content.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                String filename = (String)content.getTransferData(DataFlavor.stringFlavor);
                LOG.debug((Object)("pasted image from " + filename));
                this.loadImageFromFile("file://" + filename);
            } else {
                LOG.info((Object)("unsupported paste operation " + content));
            }
        }
        catch (Throwable e) {
            LOG.error((Object)("invalid paste operation " + e));
        }
    }

    protected void save() {
    }

    public static class Specification
    extends AbstractFieldSpecification {
        public boolean canDisplay(Content content, ViewRequirement requirement) {
            NakedObjectSpecification specification = content.getSpecification();
            return specification != null && specification.containsFacet(ImageValueFacet.class);
        }

        public View createView(Content content, ViewAxis axis) {
            return new ImageField(content, this, axis);
        }

        public String getName() {
            return "Image";
        }
    }
}

