/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd.viewer.view.field;

import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.adapter.InvalidEntryException;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.TextEntryParseException;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.plugins.dnd.Canvas;
import org.nakedobjects.plugins.dnd.Click;
import org.nakedobjects.plugins.dnd.Drag;
import org.nakedobjects.plugins.dnd.DragStart;
import org.nakedobjects.plugins.dnd.InternalDrag;
import org.nakedobjects.plugins.dnd.KeyboardAction;
import org.nakedobjects.plugins.dnd.LabelAxis;
import org.nakedobjects.plugins.dnd.SimpleInternalDrag;
import org.nakedobjects.plugins.dnd.TextParseableContent;
import org.nakedobjects.plugins.dnd.Toolkit;
import org.nakedobjects.plugins.dnd.UserActionSet;
import org.nakedobjects.plugins.dnd.View;
import org.nakedobjects.plugins.dnd.ViewAxis;
import org.nakedobjects.plugins.dnd.ViewSpecification;
import org.nakedobjects.plugins.dnd.viewer.border.BackgroundBorder;
import org.nakedobjects.plugins.dnd.viewer.border.LineBorder;
import org.nakedobjects.plugins.dnd.viewer.drawing.Color;
import org.nakedobjects.plugins.dnd.viewer.drawing.Location;
import org.nakedobjects.plugins.dnd.viewer.drawing.Size;
import org.nakedobjects.plugins.dnd.viewer.drawing.Text;
import org.nakedobjects.plugins.dnd.viewer.view.field.RevertFieldOption;
import org.nakedobjects.plugins.dnd.viewer.view.field.TextParseableFieldAbstract;
import org.nakedobjects.plugins.dnd.viewer.view.simple.TextView;
import org.nakedobjects.plugins.dnd.viewer.view.text.CursorPosition;
import org.nakedobjects.plugins.dnd.viewer.view.text.TextBlockTarget;
import org.nakedobjects.plugins.dnd.viewer.view.text.TextContent;
import org.nakedobjects.plugins.dnd.viewer.view.text.TextSelection;
import org.nakedobjects.runtime.persistence.ConcurrencyException;

public abstract class TextField
extends TextParseableFieldAbstract
implements TextBlockTarget {
    private static final Logger LOG = Logger.getLogger(TextField.class);
    protected static final Text style = Toolkit.getText("text.normal");
    protected CursorPosition cursor;
    private boolean identified;
    private String invalidReason = null;
    private boolean isSaved = true;
    private final int maxLength;
    private int displayWidth;
    protected TextSelection selection;
    private final boolean showLines;
    protected TextContent textContent;

    public TextField(TextParseableContent content, ViewSpecification specification, ViewAxis axis, boolean showLines, int wrapStyle) {
        super(content, specification, axis);
        this.showLines = showLines;
        int typicalLength = content.getTypicalLineLength();
        typicalLength = typicalLength == 0 ? 20 : typicalLength / content.getNoLines();
        this.setTextWidth(typicalLength);
        this.maxLength = content.getMaximumLength();
        this.textContent = new TextContent(this, 1, wrapStyle);
        this.cursor = new CursorPosition(this.textContent, 0, 0);
        this.selection = new TextSelection(this.textContent);
        NakedObject value = this.getValue();
        this.textContent.setText(value == null ? "" : this.titleString(value));
        this.cursor.home();
        this.isSaved = true;
    }

    protected abstract void align();

    public void contentMenuOptions(UserActionSet options) {
        super.contentMenuOptions(options);
        options.add(new RevertFieldOption(this));
    }

    protected void clear() {
        this.clearValue();
        this.editComplete(false, false);
    }

    void clearValue() {
        this.textContent.setText("");
        this.cursor.home();
        this.selection.resetTo(this.cursor);
        this.changeMade();
    }

    protected void copyToClipboard() {
        boolean noSelection = this.selection.to().samePosition(this.selection.from());
        String text = noSelection ? this.textContent.getText() : this.textContent.getText(this.selection);
        this.getViewManager().setClipboard(text, String.class);
        LOG.debug((Object)("copied " + text));
    }

    public void debug(DebugString debug) {
        super.debug(debug);
        debug.appendln("text", (Object)this.textContent);
    }

    public void delete() {
        if (this.selection.hasSelection()) {
            this.textContent.delete(this.selection);
            this.selection.resetTo(this.selection.from());
        } else {
            this.textContent.deleteLeft(this.cursor);
            this.cursor.left();
            this.selection.resetTo(this.cursor);
        }
        this.changeMade();
    }

    public void deleteForward() {
        if (this.selection.hasSelection()) {
            this.textContent.delete(this.selection);
            this.selection.resetTo(this.selection.from());
        } else {
            this.textContent.deleteRight(this.cursor);
        }
        this.changeMade();
    }

    protected void down(boolean shift) {
        this.cursor.lineDown();
        this.highlight(shift);
        this.markDamaged();
    }

    public void drag(InternalDrag drag) {
        if (this.canChangeValue().isAllowed()) {
            this.selection.extendTo(drag.getLocation());
            this.markDamaged();
        }
    }

    public Drag dragStart(DragStart drag) {
        Location at = drag.getLocation();
        Size size = this.getView().getSize();
        Location anchor = this.getView().getAbsoluteLocation();
        ViewAxis axis = this.getViewAxis();
        if (axis instanceof LabelAxis) {
            int width = ((LabelAxis)axis).getWidth();
            size.contractWidth(width);
            anchor.add(width, 0);
        }
        if (this.canChangeValue().isAllowed()) {
            this.cursor.cursorAt(at);
            this.resetSelection();
            return new SimpleInternalDrag((View)this, anchor);
        }
        this.markDamaged();
        return null;
    }

    public void dragTo(InternalDrag drag) {
        Location at = drag.getLocation();
        if (this.canChangeValue().isAllowed()) {
            this.selection.extendTo(at);
            this.markDamaged();
        }
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        int width = this.getMaxFieldWidth();
        this.align();
        if (this.hasFocus() && this.selection.hasSelection()) {
            this.drawHighlight(canvas, width);
        }
        if (this.showLines && this.canChangeValue().isAllowed()) {
            Color color = this.identified ? Toolkit.getColor("color.identified") : Toolkit.getColor("color.secondary2");
            color = this.hasFocus() ? Toolkit.getColor("color.primary1") : color;
            this.drawLines(canvas, color, width);
        }
        Color textColor = this.getState().isInvalid() ? Toolkit.getColor("color.black") : (this.hasFocus() ? (this.isSaved ? Toolkit.getColor("color.text.saved") : Toolkit.getColor("color.text.edit")) : Toolkit.getColor("color.black"));
        this.drawText(canvas, textColor, width);
    }

    protected abstract void drawHighlight(Canvas var1, int var2);

    protected abstract void drawLines(Canvas var1, Color var2, int var3);

    protected abstract void drawText(Canvas var1, Color var2, int var3);

    public void editComplete(boolean moveFocus, boolean toNextField) {
        if (this.canChangeValue().isAllowed() && !this.isSaved) {
            this.isSaved = true;
            this.initiateSave(moveFocus);
        } else if (moveFocus) {
            if (toNextField) {
                this.getFocusManager().focusNextView();
            } else {
                this.getFocusManager().focusPreviousView();
            }
        }
    }

    protected void end(boolean alt, boolean shift) {
        if (alt) {
            this.cursor.bottom();
        } else {
            this.cursor.end();
        }
        this.highlight(shift);
        this.markDamaged();
    }

    protected boolean enter() {
        this.editComplete(false, false);
        return false;
    }

    public void entered() {
        if (this.canChangeValue().isAllowed()) {
            this.getFeedbackManager().showTextCursor();
            this.identified = true;
            this.markDamaged();
        }
        super.entered();
    }

    protected void escape() {
        if (this.isSaved) {
            this.clearValue();
        } else {
            this.invalidReason = null;
            this.refresh();
            this.markDamaged();
        }
    }

    public void exited() {
        if (this.canChangeValue().isAllowed()) {
            this.getFeedbackManager().showDefaultCursor();
            this.identified = false;
            this.markDamaged();
        }
        super.exited();
    }

    public void firstClick(Click click) {
        NakedObject valueAdapter;
        if (this.canChangeValue().isAllowed()) {
            Location at = click.getLocation();
            at.subtract(HPADDING, VPADDING);
            this.cursor.cursorAt(at);
            this.resetSelection();
            if (this.cursor.getLine() > this.textContent.getNoLinesOfContent()) {
                throw new NakedObjectException("not inside content for line " + this.cursor.getLine() + " : " + this.textContent.getNoLinesOfContent());
            }
            this.markDamaged();
        }
        if ((!this.canChangeValue().isAllowed() || click.isShift() || click.button2()) && (valueAdapter = this.getContent().getNaked()) != null && valueAdapter.titleString().length() > 0) {
            BackgroundBorder textView = new BackgroundBorder(Toolkit.getColor("color.primary3"), new LineBorder(1, Toolkit.getColor("color.primary1"), (View)new TextView(this.getContent(), null, null)));
            this.getViewManager().setOverlayView(textView);
            int offset = this.getView().getPadding().getLeft();
            Location location = this.getAbsoluteLocation();
            location.add(offset, 0);
            textView.setLocation(location);
            textView.markDamaged();
        }
    }

    public void focusLost() {
        super.focusLost();
        this.editComplete(false, false);
    }

    public void focusReceived() {
        this.getFeedbackManager().setError(this.invalidReason == null ? "" : this.invalidReason);
        this.resetSelection();
    }

    public int getBaseline() {
        return this.getText().getAscent();
    }

    public Size getMaximumSize() {
        int width = HPADDING + this.displayWidth + HPADDING;
        int height = this.textContent.getNoDisplayLines() == 1 ? this.getText().getTextHeight() : this.textContent.getNoDisplayLines() * this.getText().getLineHeight();
        height = Math.max(height, Toolkit.defaultFieldHeight());
        return new Size(width, height);
    }

    public int getMaxFieldWidth() {
        return this.displayWidth;
    }

    public Text getText() {
        return style;
    }

    String getSelectedText() {
        return this.textContent.getText(this.selection);
    }

    private NakedObject getValue() {
        return this.getContent().getNaked();
    }

    private void highlight(boolean select) {
        if (this.canChangeValue().isAllowed()) {
            if (!select) {
                this.selection.resetTo(this.cursor);
            } else {
                this.selection.extendTo(this.cursor);
            }
        }
    }

    protected void home(boolean alt, boolean shift) {
        if (alt) {
            this.cursor.top();
        } else {
            this.cursor.home();
        }
        this.highlight(shift);
        this.markDamaged();
    }

    private void insert(char character) {
        if (this.withinMaximum(1)) {
            this.insert("" + character);
            this.selection.resetTo(this.cursor);
        } else {
            this.getFeedbackManager().setError("Entry can be no longer than " + this.maxLength + " characters");
        }
    }

    protected void changeMade() {
        this.isSaved = false;
        this.markDamaged();
        if (this.getState().isInvalid()) {
            this.getState().clearInvalid();
            this.getFeedbackManager().clearError();
        }
    }

    private void insert(String characters) {
        if (this.withinMaximum(characters.length())) {
            int noLines = this.textContent.getNoDisplayLines();
            this.textContent.insert(this.cursor, characters);
            this.cursor.right(characters.length());
            if (this.textContent.getNoDisplayLines() != noLines) {
                this.invalidateLayout();
            }
            this.changeMade();
        } else {
            this.getFeedbackManager().setError("Entry can be no longer than " + this.maxLength + " characters");
        }
    }

    public boolean isIdentified() {
        return this.identified;
    }

    public void keyPressed(KeyboardAction key) {
        if (!this.canChangeValue().isAllowed()) {
            return;
        }
        int keyCode = key.getKeyCode();
        if (keyCode == 17 || keyCode == 16 || keyCode == 18) {
            return;
        }
        int modifiers = key.getModifiers();
        boolean alt = (modifiers & 8) > 0;
        boolean shift = (modifiers & 1) > 0;
        boolean ctrl = (modifiers & 2) > 0;
        switch (keyCode) {
            case 33: {
                key.consume();
                this.pageUp(shift, ctrl);
                break;
            }
            case 34: {
                key.consume();
                this.pageDown(shift, ctrl);
                break;
            }
            case 86: {
                if (!ctrl) break;
                key.consume();
                this.pasteFromClipboard();
                this.highlight(false);
                break;
            }
            case 67: {
                if (!ctrl) break;
                key.consume();
                this.copyToClipboard();
                break;
            }
            case 40: {
                key.consume();
                this.down(shift);
                break;
            }
            case 38: {
                key.consume();
                this.up(shift);
                break;
            }
            case 36: {
                key.consume();
                this.home(alt, shift);
                break;
            }
            case 35: {
                key.consume();
                this.end(alt, shift);
                break;
            }
            case 37: {
                key.consume();
                this.left(alt, shift);
                break;
            }
            case 39: {
                key.consume();
                this.right(alt, shift);
                break;
            }
            case 127: {
                key.consume();
                this.deleteForward();
                break;
            }
            case 8: {
                key.consume();
                this.delete();
                break;
            }
            case 9: {
                key.consume();
                boolean moveToNextField = !shift;
                this.tab(moveToNextField);
                break;
            }
            case 10: {
                if (this.enter()) break;
                this.getParent().keyPressed(key);
                break;
            }
            case 27: {
                key.consume();
                this.escape();
                break;
            }
        }
        LOG.debug((Object)("character at " + this.cursor.getCharacter() + " line " + this.cursor.getLine()));
        LOG.debug((Object)this.selection);
    }

    public void keyReleased(int keyCode, int modifiers) {
    }

    public void keyTyped(char keyCode) {
        if (this.canChangeValue().isAllowed()) {
            this.insert(keyCode);
        }
    }

    protected void left(boolean alt, boolean shift) {
        if (alt) {
            this.cursor.wordLeft();
        } else {
            this.cursor.left();
        }
        this.highlight(shift);
        this.markDamaged();
    }

    protected void pageDown(boolean shift, boolean ctrl) {
        if (ctrl) {
            if (this.textContent.decreaseDepth()) {
                this.textContent.alignDisplay(this.cursor.getLine());
                this.invalidateLayout();
            }
        } else {
            this.cursor.pageDown();
            this.highlight(shift);
        }
        this.markDamaged();
    }

    protected void pageUp(boolean shift, boolean ctrl) {
        if (ctrl) {
            this.textContent.increaseDepth();
            this.textContent.alignDisplay(this.cursor.getLine());
            this.invalidateLayout();
        } else {
            this.cursor.pageUp();
            this.highlight(shift);
        }
        this.markDamaged();
    }

    protected void pasteFromClipboard() {
        try {
            String text = (String)this.getViewManager().getClipboard(String.class);
            this.insert(text);
            LOG.debug((Object)("pasted " + text));
        }
        catch (Throwable e) {
            LOG.error((Object)("invalid paste operation " + e));
        }
    }

    private String titleString(NakedObject object) {
        return ((TextParseableContent)this.getContent()).titleString(object);
    }

    public void refresh() {
        super.refresh();
        NakedObject object = this.getValue();
        if (object == null) {
            this.textContent.setText("");
        } else {
            this.textContent.setText(this.titleString(object));
        }
        this.isSaved = true;
    }

    private void resetSelection() {
        this.selection.resetTo(this.cursor);
    }

    protected void right(boolean alt, boolean shift) {
        if (alt) {
            this.cursor.wordRight();
        } else {
            this.cursor.right();
        }
        this.highlight(shift);
        this.markDamaged();
    }

    protected void save() {
        NakedObject value;
        String entry = this.textContent.getText();
        if (!entry.equals((value = this.getValue()) == null ? "" : value.titleString())) {
            LOG.debug((Object)("field edited: '" + entry + "' to replace '" + (value == null ? "" : value.titleString()) + "'"));
            try {
                this.parseEntry(entry.toString());
                this.invalidReason = null;
                this.getViewManager().getSpy().addAction("VALID ENTRY: " + entry);
                this.markDamaged();
                this.getParent().invalidateContent();
            }
            catch (TextEntryParseException e) {
                this.invalidReason = "Invalid Entry: " + e.getMessage();
                this.getFeedbackManager().setError(this.invalidReason);
                this.getState().setInvalid();
                this.markDamaged();
            }
            catch (InvalidEntryException e) {
                this.invalidReason = "Invalid Entry: " + e.getMessage();
                this.getFeedbackManager().setError(this.invalidReason);
                this.getState().setInvalid();
                this.markDamaged();
            }
            catch (ConcurrencyException e) {
                this.invalidReason = "Update Failure: " + e.getMessage();
                this.getState().setOutOfSynch();
                this.markDamaged();
                throw e;
            }
            catch (NakedObjectException e) {
                this.invalidReason = "Update Failure: " + e.getMessage();
                this.getFeedbackManager().setError(this.invalidReason);
                this.getState().setOutOfSynch();
                this.markDamaged();
                throw e;
            }
        }
    }

    public void secondClick(Click click) {
        if (this.canChangeValue().isAllowed()) {
            this.selection.selectWord();
        }
    }

    private void setTextWidth(int noCharacters) {
        this.displayWidth = this.getText().charWidth('5') * (noCharacters + 3);
    }

    public void setWidth(int width) {
        this.displayWidth = width;
    }

    public void setSize(Size size) {
        super.setSize(size);
        this.setWidth(size.getWidth() - 2 * HPADDING);
    }

    protected void tab(boolean moveToNextField) {
        this.editComplete(true, moveToNextField);
    }

    public void thirdClick(Click click) {
        if (this.canChangeValue().isAllowed()) {
            this.selection.selectSentence();
            this.markDamaged();
        }
    }

    protected void up(boolean shift) {
        this.cursor.lineUp();
        this.highlight(shift);
        this.markDamaged();
    }

    private boolean withinMaximum(int characters) {
        return this.maxLength == 0 || this.textContent.getText().length() + characters <= this.maxLength;
    }

    void revertInvalidEntry() {
        this.invalidReason = null;
        this.refresh();
        this.cursor.home();
        this.getState().clearInvalid();
        this.getFeedbackManager().clearError();
        this.markDamaged();
    }

    public boolean hasInvalidEntry() {
        return this.invalidReason != null;
    }
}

