/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd.viewer.view.message;

import java.util.StringTokenizer;
import org.nakedobjects.plugins.dnd.Canvas;
import org.nakedobjects.plugins.dnd.Content;
import org.nakedobjects.plugins.dnd.Toolkit;
import org.nakedobjects.plugins.dnd.ViewAreaType;
import org.nakedobjects.plugins.dnd.ViewAxis;
import org.nakedobjects.plugins.dnd.ViewSpecification;
import org.nakedobjects.plugins.dnd.viewer.drawing.Color;
import org.nakedobjects.plugins.dnd.viewer.drawing.Location;
import org.nakedobjects.plugins.dnd.viewer.drawing.Size;
import org.nakedobjects.plugins.dnd.viewer.drawing.Text;
import org.nakedobjects.plugins.dnd.viewer.view.message.MessageContent;
import org.nakedobjects.plugins.dnd.viewer.view.simple.AbstractView;

class DetailedMessageView
extends AbstractView {
    protected DetailedMessageView(Content content, ViewSpecification specification, ViewAxis axis) {
        super(content, specification, axis);
    }

    public Size getMaximumSize() {
        Size size = new Size();
        size.extendHeight(Toolkit.getText("text.title").getTextHeight());
        size.extendHeight(30);
        String message = ((MessageContent)this.getContent()).getMessage();
        size.ensureWidth(500);
        size.extendHeight(Toolkit.getText("text.normal").stringHeight(message, 500));
        size.extendHeight(30);
        String detail = ((MessageContent)this.getContent()).getDetail();
        StringTokenizer st = new StringTokenizer(detail, "\n\r");
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            Text text = Toolkit.getText("text.normal");
            size.ensureWidth((line.startsWith("\t") ? 20 : 0) + text.stringWidth(line));
            size.extendHeight(text.getTextHeight());
        }
        size.extend(40, 20);
        return size;
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        int left = 10;
        Text title = Toolkit.getText("text.title");
        int y = 10 + title.getAscent();
        String message = ((MessageContent)this.getContent()).getMessage();
        String heading = ((MessageContent)this.getContent()).title();
        String detail = ((MessageContent)this.getContent()).getDetail();
        Color black = Toolkit.getColor("color.black");
        canvas.drawText(heading, 10, y, black, title);
        Text text = Toolkit.getText("text.normal");
        canvas.drawText(message, 10, y += title.getTextHeight(), 500, black, text);
        canvas.drawText(detail, 10, y += text.stringHeight(message, 500), 1000, Toolkit.getColor("color.primary1"), text);
    }

    public ViewAreaType viewAreaType(Location mouseLocation) {
        return ViewAreaType.VIEW;
    }
}

