/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd.viewer.view.message;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.commons.exceptions.ExceptionHelper;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectApplicationException;
import org.nakedobjects.metamodel.commons.names.NameConvertorUtils;
import org.nakedobjects.metamodel.consent.Consent;
import org.nakedobjects.metamodel.consent.Veto;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.plugins.dnd.Content;
import org.nakedobjects.plugins.dnd.UserActionSet;
import org.nakedobjects.plugins.dnd.viewer.drawing.Image;
import org.nakedobjects.plugins.dnd.viewer.view.message.MessageContent;
import org.nakedobjects.runtime.persistence.ConcurrencyException;

public class ExceptionMessageContent
implements MessageContent {
    protected String message;
    protected String name;
    protected String trace;
    protected String title;
    private final String icon;

    public ExceptionMessageContent(Throwable error) {
        String fullName = error.getClass().getName();
        fullName = fullName.substring(fullName.lastIndexOf(46) + 1);
        this.name = NameConvertorUtils.naturalName((String)fullName);
        this.message = error.getMessage();
        this.trace = ExceptionHelper.exceptionTraceAsString((Throwable)error);
        if (this.trace.indexOf("\tat") != -1) {
            this.trace = this.trace.substring(this.trace.indexOf("\tat"));
        }
        if (this.name == null) {
            this.name = "";
        }
        if (this.message == null) {
            this.message = "";
        }
        if (this.trace == null) {
            this.trace = "";
        }
        if (error instanceof NakedObjectApplicationException) {
            this.title = "Application Error";
            this.icon = "application-error";
        } else if (error instanceof ConcurrencyException) {
            this.title = "Concurrency Error";
            this.icon = "concurrency-error";
        } else {
            this.title = "System Error";
            this.icon = "system-error";
        }
    }

    public String getMessage() {
        return this.message;
    }

    public String getDetail() {
        return this.trace;
    }

    public String getIconName() {
        return this.icon;
    }

    public Consent canDrop(Content sourceContent) {
        return Veto.DEFAULT;
    }

    public void contentMenuOptions(UserActionSet options) {
    }

    public void debugDetails(DebugString debug) {
    }

    public NakedObject drop(Content sourceContent) {
        return null;
    }

    public String getDescription() {
        return this.name;
    }

    public String getHelp() {
        return "";
    }

    public Image getIconPicture(int iconHeight) {
        return null;
    }

    public String getId() {
        return "message-exception";
    }

    public NakedObject getNaked() {
        return null;
    }

    public NakedObject[] getOptions() {
        return null;
    }

    public NakedObjectSpecification getSpecification() {
        return null;
    }

    public boolean isCollection() {
        return false;
    }

    public boolean isObject() {
        return false;
    }

    public boolean isOptionEnabled() {
        return false;
    }

    public boolean isPersistable() {
        return false;
    }

    public boolean isTransient() {
        return false;
    }

    public boolean isTextParseable() {
        return false;
    }

    public void parseTextEntry(String entryText) {
    }

    public String title() {
        return this.name;
    }

    public void viewMenuOptions(UserActionSet options) {
    }

    public String windowTitle() {
        return this.title;
    }
}

