/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd.viewer.view.simple;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.plugins.dnd.Canvas;
import org.nakedobjects.plugins.dnd.Content;
import org.nakedobjects.plugins.dnd.Toolkit;
import org.nakedobjects.plugins.dnd.View;
import org.nakedobjects.plugins.dnd.ViewAxis;
import org.nakedobjects.plugins.dnd.ViewSpecification;
import org.nakedobjects.plugins.dnd.viewer.drawing.Image;
import org.nakedobjects.plugins.dnd.viewer.drawing.Size;
import org.nakedobjects.plugins.dnd.viewer.image.ImageFactory;
import org.nakedobjects.plugins.dnd.viewer.view.graphic.IconGraphic;
import org.nakedobjects.plugins.dnd.viewer.view.simple.ObjectView;
import org.nakedobjects.plugins.dnd.viewer.view.text.ObjectTitleText;
import org.nakedobjects.plugins.dnd.viewer.view.text.TitleText;

public class Icon
extends ObjectView {
    private IconGraphic icon;
    private boolean isVertical;
    private IconGraphic selectedGraphic;
    private TitleText title;
    private IconGraphic unselectedGraphic;

    public Icon(Content content, ViewSpecification specification, ViewAxis axis) {
        super(content, specification, axis);
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        this.ensureHasIcon();
        int x = 0;
        int y = 0;
        this.icon.draw(canvas, x, 0);
        if (this.isVertical) {
            int w = this.title.getSize().getWidth();
            x = w > this.icon.getSize().getWidth() ? x : this.getSize().getWidth() / 2 - w / 2;
            y = this.icon.getSize().getHeight() + Toolkit.getText("text.icon").getAscent() + VPADDING;
        } else {
            x += this.icon.getSize().getWidth();
            x += View.HPADDING;
            y = this.icon.getBaseline();
        }
        this.title.draw(canvas, x, y);
        if (this.getState().isActive()) {
            Image busyImage = ImageFactory.getInstance().loadIcon("busy", 16, null);
            canvas.drawImage(busyImage, this.icon.getSize().getWidth() - 16 - 4, 4);
        }
    }

    private void ensureHasIcon() {
        if (this.icon == null) {
            this.icon = this.selectedGraphic;
        }
    }

    public void entered() {
        this.icon = this.selectedGraphic;
        this.markDamaged();
        super.entered();
    }

    public void exited() {
        this.icon = this.unselectedGraphic;
        this.markDamaged();
        super.exited();
    }

    public int getBaseline() {
        this.ensureHasIcon();
        return this.icon.getBaseline();
    }

    public Size getMaximumSize() {
        if (this.icon == null) {
            this.icon = this.selectedGraphic;
        }
        Size size = this.icon.getSize();
        Size textSize = this.title.getSize();
        if (this.isVertical) {
            size.extendHeight(VPADDING + textSize.getHeight() + VPADDING);
            size.ensureWidth(textSize.getWidth());
        } else {
            size.extendWidth(View.HPADDING);
            size.extendWidth(textSize.getWidth());
        }
        return size;
    }

    public void setSelectedIcon(IconGraphic selectedGraphic) {
        this.selectedGraphic = selectedGraphic;
    }

    public void setTitle(ObjectTitleText text) {
        this.title = text;
    }

    public void setUnselectedGraphic(IconGraphic unselectedGraphic) {
        this.unselectedGraphic = unselectedGraphic;
    }

    public void setVertical(boolean isVertical) {
        this.isVertical = isVertical;
    }

    public void update(NakedObject object) {
        View p = this.getParent();
        if (p != null) {
            p.invalidateLayout();
        }
    }
}

