/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd.viewer.view.simple;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.consent.Consent;
import org.nakedobjects.metamodel.spec.feature.NakedObjectActionConstants;
import org.nakedobjects.plugins.dnd.Click;
import org.nakedobjects.plugins.dnd.Content;
import org.nakedobjects.plugins.dnd.ContentDrag;
import org.nakedobjects.plugins.dnd.Drag;
import org.nakedobjects.plugins.dnd.DragStart;
import org.nakedobjects.plugins.dnd.Toolkit;
import org.nakedobjects.plugins.dnd.UserActionSet;
import org.nakedobjects.plugins.dnd.View;
import org.nakedobjects.plugins.dnd.ViewAxis;
import org.nakedobjects.plugins.dnd.ViewDrag;
import org.nakedobjects.plugins.dnd.ViewSpecification;
import org.nakedobjects.plugins.dnd.Workspace;
import org.nakedobjects.plugins.dnd.viewer.action.AbstractUserAction;
import org.nakedobjects.plugins.dnd.viewer.drawing.Location;
import org.nakedobjects.plugins.dnd.viewer.drawing.Offset;
import org.nakedobjects.plugins.dnd.viewer.view.simple.AbstractView;
import org.nakedobjects.plugins.dnd.viewer.view.simple.DragViewOutline;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.PersistenceSession;

public abstract class ObjectView
extends AbstractView {
    public ObjectView(Content content, ViewSpecification specification, ViewAxis axis) {
        super(content, specification, axis);
    }

    public void dragIn(ContentDrag drag) {
        Consent consent = this.getContent().canDrop(drag.getSourceContent());
        String description = this.getContent().getDescription();
        if (consent.isAllowed()) {
            this.getFeedbackManager().setAction(consent.getDescription() + " " + description);
            this.getState().setCanDrop();
        } else {
            this.getFeedbackManager().setAction(consent.getReason() + " " + description);
            this.getState().setCantDrop();
        }
        this.markDamaged();
    }

    public void dragOut(ContentDrag drag) {
        this.getState().clearObjectIdentified();
        this.markDamaged();
    }

    public Drag dragStart(DragStart drag) {
        View subview = this.subviewFor(drag.getLocation());
        if (subview != null) {
            drag.subtract(subview.getLocation());
            return subview.dragStart(drag);
        }
        if (drag.isCtrl()) {
            DragViewOutline dragOverlay = new DragViewOutline(this.getView());
            return new ViewDrag(this, new Offset(drag.getLocation()), dragOverlay);
        }
        View dragOverlay = Toolkit.getViewFactory().getContentDragSpecification().createView(this.getContent(), null);
        return new ContentDrag(this, drag.getLocation(), dragOverlay);
    }

    public void drop(ContentDrag drag) {
        NakedObject result = this.getContent().drop(drag.getSourceContent());
        if (result != null) {
            View view = this.getWorkspace().createSubviewFor(result, false);
            Location location = new Location();
            location.move(10, 10);
            view.setLocation(location);
            this.getWorkspace().addView(view);
        }
        this.getState().clearObjectIdentified();
        this.getFeedbackManager().showMessagesAndWarnings();
        this.markDamaged();
    }

    public void firstClick(Click click) {
        View subview = this.subviewFor(click.getLocation());
        if (subview != null) {
            click.subtract(subview.getLocation());
            subview.firstClick(click);
        } else if (click.button2()) {
            Location location = new Location(click.getLocationWithinViewer());
            this.getViewManager().showInOverlay(this.getContent(), location);
        }
    }

    public void invalidateContent() {
        super.invalidateLayout();
    }

    public void secondClick(Click click) {
        View subview = this.subviewFor(click.getLocation());
        if (subview != null) {
            click.subtract(subview.getLocation());
            subview.secondClick(click);
        } else {
            Location location = this.getAbsoluteLocation();
            location.translate(click.getLocation());
            this.getWorkspace().addWindowFor(this.getContent().getNaked(), location);
        }
    }

    public void contentMenuOptions(UserActionSet options) {
        super.contentMenuOptions(options);
        options.add(new AbstractUserAction("Reload", NakedObjectActionConstants.DEBUG){

            public void execute(Workspace workspace, View view, Location at) {
                NakedObject object = ObjectView.this.getContent().getNaked();
                ObjectView.getPersistenceSession().reload(object);
            }
        });
    }

    private static PersistenceSession getPersistenceSession() {
        return NakedObjectsContext.getPersistenceSession();
    }
}

