/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd.viewer.view.text;

import org.nakedobjects.plugins.dnd.viewer.drawing.Location;
import org.nakedobjects.plugins.dnd.viewer.view.text.CursorPosition;
import org.nakedobjects.plugins.dnd.viewer.view.text.TextContent;

public class TextSelection {
    private final CursorPosition cursor;
    private final CursorPosition start;

    public TextSelection(TextContent content) {
        this.cursor = new CursorPosition(content, 0, 0);
        this.start = new CursorPosition(content, 0, 0);
    }

    private boolean backwardSelection() {
        return this.cursor.isBefore(this.start);
    }

    public void extendTo(CursorPosition pos) {
        this.cursor.asFor(pos);
    }

    public void extendTo(Location at) {
        this.cursor.cursorAt(at);
    }

    public CursorPosition from() {
        return this.backwardSelection() ? this.cursor : this.start;
    }

    public boolean hasSelection() {
        return !this.cursor.samePosition(this.start);
    }

    public void resetTo(CursorPosition pos) {
        this.start.asFor(pos);
        this.cursor.asFor(pos);
    }

    public void selectSentence() {
        this.resetTo(this.cursor);
        this.start.home();
        this.cursor.end();
    }

    public void selectWord() {
        this.resetTo(this.cursor);
        this.start.wordLeft();
        this.cursor.wordRight();
    }

    public CursorPosition to() {
        return this.backwardSelection() ? this.start : this.cursor;
    }

    public String toString() {
        return "Selection [from=" + this.start.getLine() + ":" + this.start.getCharacter() + ",to=" + this.cursor.getLine() + ":" + this.cursor.getCharacter() + "]";
    }
}

