/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd;

import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.plugins.dnd.ColorsAndFonts;
import org.nakedobjects.plugins.dnd.ContentFactory;
import org.nakedobjects.plugins.dnd.Feedback;
import org.nakedobjects.plugins.dnd.ViewFactory;
import org.nakedobjects.plugins.dnd.Viewer;
import org.nakedobjects.plugins.dnd.viewer.drawing.Color;
import org.nakedobjects.plugins.dnd.viewer.drawing.Text;

public abstract class Toolkit {
    public static boolean debug = false;
    private static Toolkit instance;
    protected ContentFactory contentFactory;
    protected ColorsAndFonts colorsAndFonts;
    protected Viewer viewer;
    protected Feedback feedbackManager;
    protected ViewFactory viewFactory;

    public static int defaultBaseline() {
        return Toolkit.getInstance().colorsAndFonts.defaultBaseline();
    }

    public static int defaultFieldHeight() {
        return Toolkit.getInstance().colorsAndFonts.defaultFieldHeight();
    }

    public static Color getColor(int rgbColor) {
        return Toolkit.instance.colorsAndFonts.getColor(rgbColor);
    }

    public static Color getColor(String name) {
        Color color = Toolkit.getInstance().colorsAndFonts.getColor(name);
        if (color == null) {
            throw new NakedObjectException("No such color: " + name);
        }
        return color;
    }

    public static ContentFactory getContentFactory() {
        return Toolkit.getInstance().contentFactory;
    }

    protected static Toolkit getInstance() {
        return instance;
    }

    public static Text getText(String name) {
        Text text = Toolkit.getInstance().colorsAndFonts.getText(name);
        if (text == null) {
            throw new NakedObjectException("No such text style: " + name);
        }
        return text;
    }

    public static Viewer getViewer() {
        return Toolkit.getInstance().viewer;
    }

    public static Feedback getFeedbackManager() {
        return Toolkit.getInstance().feedbackManager;
    }

    public static ViewFactory getViewFactory() {
        return Toolkit.getInstance().viewFactory;
    }

    protected Toolkit() {
        if (instance != null) {
            throw new IllegalStateException("Toolkit already instantiated");
        }
        instance = this;
        this.init();
    }

    protected abstract void init();
}

