/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd;

import org.nakedobjects.plugins.dnd.Drag;
import org.nakedobjects.plugins.dnd.View;
import org.nakedobjects.plugins.dnd.Viewer;
import org.nakedobjects.plugins.dnd.Workspace;
import org.nakedobjects.plugins.dnd.viewer.drawing.Location;
import org.nakedobjects.plugins.dnd.viewer.drawing.Offset;

public class ViewDrag
extends Drag {
    private final View dragView;
    private Location location;
    private final Offset overlayOffset;
    private final View view;
    private final View viewsDecoratedWorkspace;
    private final Workspace viewsWorkspace;

    public ViewDrag(View view, Offset offset, View dragView) {
        this.view = view;
        this.dragView = dragView;
        this.overlayOffset = offset;
        this.viewsWorkspace = view.getWorkspace();
        this.viewsDecoratedWorkspace = this.viewsWorkspace.getView();
    }

    public void cancel(Viewer viewer) {
        this.getSourceView().getFeedbackManager().showDefaultCursor();
    }

    protected void drag(Viewer viewer) {
        if (this.dragView != null) {
            this.dragView.markDamaged();
            this.updateDraggingLocation();
            this.dragView.markDamaged();
        }
    }

    public void drag(View target, Location location, int mods) {
        this.location = location;
        if (this.dragView != null) {
            this.dragView.markDamaged();
            this.updateDraggingLocation();
            this.dragView.markDamaged();
        }
    }

    public void end(Viewer viewer) {
        viewer.clearAction();
        this.viewsDecoratedWorkspace.drop(this);
    }

    public View getOverlay() {
        return this.dragView;
    }

    public Location getLocation() {
        return this.location;
    }

    public View getSourceView() {
        return this.view;
    }

    public Location getViewDropLocation() {
        Location viewLocation = new Location(this.location);
        viewLocation.subtract(this.overlayOffset);
        viewLocation.subtract(this.viewsDecoratedWorkspace.getAbsoluteLocation());
        viewLocation.move(-this.viewsDecoratedWorkspace.getPadding().getLeft(), -this.viewsDecoratedWorkspace.getPadding().getTop());
        return viewLocation;
    }

    public void subtract(Location location) {
        location.subtract(location);
    }

    public String toString() {
        return "ViewDrag [" + super.toString() + "]";
    }

    private void updateDraggingLocation() {
        Location viewLocation = new Location(this.location);
        viewLocation.subtract(this.overlayOffset);
        this.dragView.setLocation(viewLocation);
        this.dragView.limitBoundsWithin(this.viewsWorkspace.getSize());
    }

    public void subtract(int x, int y) {
        this.location.subtract(x, y);
    }
}

