/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd;

import org.nakedobjects.plugins.dnd.Content;
import org.nakedobjects.plugins.dnd.ViewAxis;

public class ViewRequirement {
    public static final int NONE = 0;
    public static final int CLOSED = 1;
    public static final int SUMMARY = 2;
    public static final int OPEN = 4;
    public static final int EDITABLE = 16;
    public static final int REPLACEABLE = 256;
    public static final int EXPANDABLE = 512;
    public static final int ROOT = 4096;
    public static final int SUBVIEW = 8192;
    private final Content content;
    private final ViewAxis viewAxis;
    private final int status;

    public ViewRequirement(Content content, ViewAxis viewAxis, int status) {
        this.content = content;
        this.viewAxis = viewAxis;
        this.status = status;
        status = 1;
    }

    public ViewRequirement(Content content, int status) {
        this(content, null, status);
    }

    public Content getContent() {
        return this.content;
    }

    public ViewAxis getAxis() {
        return this.viewAxis;
    }

    public boolean is(int status) {
        return (this.status & status) == status;
    }

    public boolean isClosed() {
        return this.is(1);
    }

    public boolean isEditable() {
        return this.is(16);
    }
}

