/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dnd.viewer;

import java.util.Hashtable;
import org.nakedobjects.plugins.dnd.ColorsAndFonts;
import org.nakedobjects.plugins.dnd.View;
import org.nakedobjects.plugins.dnd.viewer.AwtColor;
import org.nakedobjects.plugins.dnd.viewer.AwtText;
import org.nakedobjects.plugins.dnd.viewer.drawing.Color;
import org.nakedobjects.plugins.dnd.viewer.drawing.Text;

public class AwtColorsAndFonts
implements ColorsAndFonts {
    private final Hashtable colors = new Hashtable();
    private int defaultBaseline;
    private int defaultFieldHeight;
    private final Hashtable fonts = new Hashtable();

    public int defaultBaseline() {
        if (this.defaultBaseline == 0) {
            int iconSize = this.getText("text.normal").getAscent();
            this.defaultBaseline = View.VPADDING + iconSize;
        }
        return this.defaultBaseline;
    }

    public int defaultFieldHeight() {
        if (this.defaultFieldHeight == 0) {
            this.defaultFieldHeight = this.getText("text.normal").getTextHeight();
        }
        return this.defaultFieldHeight;
    }

    public Color getColor(String name) {
        Color color = (Color)this.colors.get(name);
        if (color == null && name.startsWith("color.background.window.")) {
            color = new AwtColor(name, (AwtColor)this.getColor("color.background.window"));
            this.colors.put(name, color);
        }
        return color;
    }

    public Color getColor(int rgbColor) {
        return new AwtColor(rgbColor);
    }

    public Text getText(String name) {
        return (Text)this.fonts.get(name);
    }

    public void init() {
        this.setColor("color.black", "#000000");
        this.setColor("color.white", "#ffffff");
        this.setColor("color.primary1", "#666699");
        this.setColor("color.primary2", "#9999cc");
        this.setColor("color.primary3", "#ccccff");
        this.setColor("color.secondary1", "#666666");
        this.setColor("color.secondary2", "#999999");
        this.setColor("color.secondary3", "#cccccc");
        this.setColor("color.background.application", "#e0e0e0");
        this.setColor("color.background.window", this.getColor("color.white"));
        this.setColor("color.background.menu.value", this.getColor("color.primary3"));
        this.setColor("color.background.menu.content", this.getColor("color.primary3"));
        this.setColor("color.background.menu.view", this.getColor("color.secondary3"));
        this.setColor("color.background.menu.workspace", this.getColor("color.secondary3"));
        this.setColor("color.menu.normal", this.getColor("color.black"));
        this.setColor("color.menu.disabled", this.getColor("color.secondary1"));
        this.setColor("color.menu.reversed", this.getColor("color.white"));
        this.setColor("color.label.normal", this.getColor("color.black"));
        this.setColor("color.label.disabled", this.getColor("color.secondary1"));
        this.setColor("color.label.mandatory", this.getColor("color.black"));
        this.setColor("color.identified", this.getColor("color.primary3"));
        this.setColor("color.valid", "#32CD32");
        this.setColor("color.invalid", "#ee1919");
        this.setColor("color.error", "#ee1919");
        this.setColor("color.active", "#ff0000");
        this.setColor("color.out-of-sync", "#662200");
        this.setColor("color.text.saved", this.getColor("color.secondary1"));
        this.setColor("color.text.edit", this.getColor("color.primary1"));
        this.setColor("color.text.cursor", this.getColor("color.primary1"));
        this.setColor("color.text.highlight", this.getColor("color.primary3"));
        this.setColor("color.debug.baseline", AwtColor.DEBUG_BASELINE);
        this.setColor("color.debug.bounds.border", AwtColor.DEBUG_BORDER_BOUNDS);
        this.setColor("color.debug.bounds.draw", AwtColor.DEBUG_DRAW_BOUNDS);
        this.setColor("color.debug.bounds.repaint", AwtColor.DEBUG_REPAINT_BOUNDS);
        this.setColor("color.debug.bounds.view", AwtColor.DEBUG_VIEW_BOUNDS);
        this.setText("text.control", "SansSerif-bold-12");
        this.setText("text.title", "SansSerif-bold-12");
        this.setText("text.title.small", "SansSerif-bold-12");
        this.setText("text.status", "SansSerif--12");
        this.setText("text.icon", "SansSerif-bold-12");
        this.setText("text.label.mandatory", "SansSerif-bold-11");
        this.setText("text.label.disabled", "SansSerif-italic-11");
        this.setText("text.label", "SansSerif--11");
        this.setText("text.menu", "SansSerif--12");
        this.setText("text.normal", "SansSerif-plain-12");
    }

    private void setColor(String name, Color defaultColor) {
        this.setColor(name, (AwtColor)defaultColor);
    }

    private void setColor(String name, AwtColor defaultColor) {
        if (this.getColor(name) == null) {
            AwtColor color = new AwtColor(name, defaultColor);
            this.colors.put(name, color);
        }
    }

    private void setColor(String name, String defaultColor) {
        if (this.getColor(name) == null) {
            AwtColor color = new AwtColor(name, defaultColor);
            this.colors.put(name, color);
        }
    }

    private void setText(String name, String defaultFont) {
        if (this.getText(name) == null) {
            AwtText font = new AwtText(name, defaultFont);
            this.fonts.put(name, font);
        }
    }
}

